/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules.units;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.rules.DataSource;

public interface AssignableChecker {
    public boolean isAssignableFrom(Class<?> var1, Class<?> var2);

    public static AssignableChecker create(ClassLoader classLoader) {
        return AssignableChecker.create(classLoader, classLoader != DataSource.class.getClassLoader());
    }

    public static AssignableChecker create(ClassLoader classLoader, boolean classLoaderSafe) {
        return classLoaderSafe ? new ClassLoaderSafeAssignableChecker(classLoader) : DummyAssignableChecker.INSTANCE;
    }

    public static class ClassLoaderSafeAssignableChecker
    implements AssignableChecker {
        private final ClassLoader classLoader;
        private final Map<String, Class<?>> classes = new HashMap();

        public ClassLoaderSafeAssignableChecker(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public boolean isAssignableFrom(Class<?> source, Class<?> target) {
            return this.classes.computeIfAbsent(source.getCanonicalName(), name -> {
                try {
                    return this.classLoader.loadClass((String)name);
                }
                catch (ClassNotFoundException e) {
                    return source;
                }
            }).isAssignableFrom(target);
        }
    }

    public static enum DummyAssignableChecker implements AssignableChecker
    {
        INSTANCE;


        @Override
        public boolean isAssignableFrom(Class<?> source, Class<?> target) {
            return source.isAssignableFrom(target);
        }
    }
}

