/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules.units;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.kogito.factory.KogitoInternalFactHandle;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.ruleunit.InternalStoreCallback;
import org.drools.core.spi.Activation;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.kogito.rules.DataHandle;
import org.kie.kogito.rules.DataProcessor;
import org.kie.kogito.rules.DataStore;
import org.kie.kogito.rules.units.EntryPointDataProcessor;
import org.kie.kogito.rules.units.impl.DataHandleImpl;

public class ListDataStore<T>
implements DataStore<T>,
InternalStoreCallback {
    private final Map<Object, DataHandle> store = new IdentityHashMap<Object, DataHandle>();
    private final List<EntryPointDataProcessor> entryPointSubscribers = new ArrayList<EntryPointDataProcessor>();
    private final List<DataProcessor<T>> subscribers = new ArrayList<DataProcessor<T>>();

    public DataHandle add(T t) {
        DataHandleImpl dh = new DataHandleImpl(t);
        this.store.put(t, dh);
        this.entryPointSubscribers.forEach(s -> this.internalInsert(dh, (DataProcessor)s));
        this.subscribers.forEach(s -> this.internalInsert(dh, (DataProcessor)s));
        return dh;
    }

    public void update(DataHandle handle, T object) {
        this.entryPointSubscribers.forEach(s -> s.update(handle, handle.getObject()));
        this.subscribers.forEach(s -> s.update(handle, object));
    }

    public void remove(Object object) {
        this.remove(this.store.get(object));
    }

    public void remove(DataHandle handle) {
        this.entryPointSubscribers.forEach(s -> s.delete(handle));
        this.subscribers.forEach(s -> s.delete(handle));
        this.store.remove(handle.getObject());
    }

    public void subscribe(DataProcessor processor) {
        if (processor instanceof EntryPointDataProcessor) {
            EntryPointDataProcessor subscriber = (EntryPointDataProcessor)processor;
            this.entryPointSubscribers.add(subscriber);
        } else {
            this.subscribers.add(processor);
        }
        this.store.values().forEach(dh -> this.internalInsert((DataHandle)dh, processor));
    }

    public void update(KogitoInternalFactHandle fh, Object obj, BitMask mask, Class<?> modifiedClass, Activation activation) {
        DataHandle dh = fh.getDataHandle();
        this.entryPointSubscribers.forEach(s -> s.update(dh, obj, mask, modifiedClass, activation));
        this.subscribers.forEach(s -> s.update(dh, obj));
    }

    public void delete(KogitoInternalFactHandle fh, RuleImpl rule, TerminalNode terminalNode, FactHandle.State fhState) {
        DataHandle dh = fh.getDataHandle();
        this.entryPointSubscribers.forEach(s -> s.delete(dh, rule, terminalNode, fhState));
        this.subscribers.forEach(s -> s.delete(dh));
        this.store.remove(fh.getObject());
    }

    private void internalInsert(DataHandle dh, DataProcessor s) {
        FactHandle fh = s.insert(dh, dh.getObject());
        if (fh != null) {
            ((KogitoInternalFactHandle)fh).setDataStore((InternalStoreCallback)this);
            ((KogitoInternalFactHandle)fh).setDataHandle(dh);
        }
    }
}

