/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules.units;

import java.util.ArrayList;
import java.util.List;
import org.kie.kogito.rules.DataProcessor;
import org.kie.kogito.rules.DataStream;

public class ListDataStream<T>
implements DataStream<T> {
    private final ArrayList<T> values = new ArrayList();
    private final List<DataProcessor> subscribers = new ArrayList<DataProcessor>();

    @SafeVarargs
    public static <T> ListDataStream<T> create(T ... ts) {
        ListDataStream<T> stream = new ListDataStream<T>();
        for (T t : ts) {
            stream.append(t);
        }
        return stream;
    }

    public void append(T t) {
        this.values.add(t);
        this.subscribers.forEach(s -> s.insert(t));
    }

    public void subscribe(DataProcessor subscriber) {
        this.subscribers.add(subscriber);
        this.values.forEach(arg_0 -> ((DataProcessor)subscriber).insert(arg_0));
    }
}

