/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.events.EventDefinition;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.kie.api.definition.process.Process;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.parser.DefaultNodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.NodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandlerFactory;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class ServerlessWorkflowParser {
    public static final String NODE_START_NAME = "Start";
    public static final String NODE_END_NAME = "End";
    public static final String DEFAULT_NAME = "workflow";
    public static final String DEFAULT_PACKAGE = "org.kie.kogito.serverless";
    public static final String DEFAULT_VERSION = "1.0";
    public static final String JSON_NODE = "com.fasterxml.jackson.databind.JsonNode";
    public static final String DEFAULT_WORKFLOW_VAR = "workflowdata";
    private NodeIdGenerator idGenerator = DefaultNodeIdGenerator.get();
    private Workflow workflow;
    private Process process;
    private KogitoBuildContext context;

    public static ServerlessWorkflowParser of(Reader workflowFile, String workflowFormat, KogitoBuildContext context) throws IOException {
        return ServerlessWorkflowParser.of((Workflow)ServerlessWorkflowUtils.getObjectMapper(workflowFormat).readValue(workflowFile, Workflow.class), context);
    }

    public static ServerlessWorkflowParser of(Workflow workflow, KogitoBuildContext context) {
        return new ServerlessWorkflowParser(workflow, context);
    }

    public ServerlessWorkflowParser withIdGenerator(NodeIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    private ServerlessWorkflowParser(Workflow workflow, KogitoBuildContext context) {
        this.workflow = workflow;
        this.context = context;
    }

    private Process parseProcess() {
        String workflowStartStateName = this.workflow.getStart().getStateName();
        if (workflowStartStateName == null || workflowStartStateName.trim().isEmpty()) {
            throw new IllegalArgumentException("workflow does not define a starting state");
        }
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)this.workflow.getId()).name(this.workflow.getName() == null ? DEFAULT_NAME : this.workflow.getName()).version(this.workflow.getVersion() == null ? DEFAULT_VERSION : this.workflow.getVersion()).packageName(this.workflow.getMetadata() != null ? this.workflow.getMetadata().getOrDefault("package", DEFAULT_PACKAGE) : DEFAULT_PACKAGE).visibility("Public").variable(DEFAULT_WORKFLOW_VAR, (DataType)new ObjectDataType(JsonNode.class), (Object)ObjectMapperFactory.get().createObjectNode());
        ParserContext parserContext = new ParserContext(this.idGenerator, factory, this.context);
        Collection handlers = this.workflow.getStates().stream().map(state -> StateHandlerFactory.getStateHandler(state, this.workflow, parserContext)).filter(Optional::isPresent).map(Optional::get).filter(state -> !state.usedForCompensation()).collect(Collectors.toList());
        handlers.forEach(StateHandler::handleStart);
        handlers.forEach(StateHandler::handleEnd);
        handlers.forEach(StateHandler::handleState);
        handlers.forEach(StateHandler::handleTransitions);
        handlers.forEach(StateHandler::handleErrors);
        handlers.forEach(StateHandler::handleConnections);
        if (parserContext.isCompensation()) {
            factory.metaData("Compensation", (Object)true);
            factory.addCompensationContext(this.workflow.getId());
        }
        return factory.validate().getProcess();
    }

    public Process getProcess() {
        if (this.process == null) {
            this.process = this.parseProcess();
        }
        return this.process;
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> SubProcessNodeFactory<T> subprocessNode(SubProcessNodeFactory<T> nodeFactory) {
        Map<String, String> types = Collections.singletonMap(DEFAULT_WORKFLOW_VAR, JSON_NODE);
        DataAssociation da = new DataAssociation(new DataDefinition(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR, JSON_NODE), new DataDefinition(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR, JSON_NODE), null, null);
        VariableScope variableScope = new VariableScope();
        return (SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)nodeFactory.independent(true).metaData("BPMN.InputTypes", types)).metaData("BPMN.OutputTypes", types)).mapDataInputAssociation(da)).mapDataOutputAssociation(da)).context((Context)variableScope)).defaultContext((Context)variableScope);
    }

    public static <T extends NodeFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>> T sendEventNode(T actionNode, EventDefinition eventDefinition) {
        return (T)actionNode.name(eventDefinition.getName()).metaData("TriggerType", (Object)"ProduceMessage").metaData("MappingVariable", (Object)DEFAULT_WORKFLOW_VAR).metaData("TriggerRef", (Object)eventDefinition.getType()).metaData("MessageType", (Object)JSON_NODE);
    }

    public static <T extends NodeFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>> T messageNode(T nodeFactory, EventDefinition eventDefinition, String inputVar) {
        return (T)nodeFactory.name(eventDefinition.getName()).metaData("EventType", (Object)"message").metaData("TriggerMapping", (Object)inputVar).metaData("TriggerRef", (Object)eventDefinition.getType()).metaData("MessageType", (Object)JSON_NODE).metaData("TriggerType", (Object)"ConsumeMessage");
    }
}

