/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.filters.ActionDataFilter;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.interfaces.State;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jbpm.compiler.canonical.descriptors.AbstractServiceTaskDescriptor;
import org.jbpm.compiler.canonical.descriptors.OpenApiTaskDescriptor;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.AbstractCompositeNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.process.workitems.impl.expr.ExpressionHandlerFactory;
import org.kie.kogito.process.workitems.impl.expr.ExpressionWorkItemResolver;
import org.kie.kogito.serverless.workflow.JsonNodeResolver;
import org.kie.kogito.serverless.workflow.ObjectResolver;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.suppliers.ExpressionActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.RestBodyBuilderSupplier;
import org.kie.kogito.serverless.workflow.suppliers.SysoutActionSupplier;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public abstract class CompositeContextNodeHandler<S extends State>
extends StateHandler<S> {
    private static final String SCRIPT_TYPE = "script";
    private static final String REST_TYPE = "rest";
    private static final String SCRIPT_TYPE_PARAM = "script";
    private static final String SYSOUT_TYPE = "sysout";
    private static final String SYSOUT_TYPE_PARAM = "message";
    private static final String SERVICE_TYPE = "service";
    private static final String SERVICE_TASK_TYPE = "Service Task";
    private static final String WORKITEM_INTERFACE = "Interface";
    private static final String WORKITEM_OPERATION = "Operation";
    private static final String WORKITEM_INTERFACE_IMPL = "interfaceImplementationRef";
    private static final String WORKITEM_OPERATION_IMPL = "operationImplementationRef";
    private static final String WORKITEM_PARAM_TYPE = "ParameterType";
    private static final String WORKITEM_PARAM = "Parameter";
    private static final String WORKITEM_RESULT = "Result";
    private static final String SERVICE_INTERFACE_KEY = "interface";
    private static final String SERVICE_OPERATION_KEY = "operation";
    private static final String SERVICE_IMPL_KEY = "implementation";

    protected CompositeContextNodeHandler(S state, Workflow workflow, ParserContext parserContext) {
        super(state, workflow, parserContext);
    }

    protected final CompositeContextNodeFactory<?> makeCompositeNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        return (CompositeContextNodeFactory)((CompositeContextNodeFactory)factory.compositeContextNode(this.parserContext.newId()).name(this.state.getName())).autoComplete(true);
    }

    protected final <T extends AbstractCompositeNodeFactory<?, ?>> T handleActions(T embeddedSubProcess, List<io.serverlessworkflow.api.actions.Action> actions) {
        return this.handleActions(embeddedSubProcess, actions, null, new String[0]);
    }

    protected final <T extends AbstractCompositeNodeFactory<?, ?>> T handleActions(T embeddedSubProcess, List<io.serverlessworkflow.api.actions.Action> actions, String outputVar, String ... extraVariables) {
        if (actions != null && !actions.isEmpty()) {
            NodeFactory<?, ?> startNode;
            NodeFactory<?, ?> currentNode = startNode = embeddedSubProcess.startNode(this.parserContext.newId()).name("EmbeddedStart");
            for (io.serverlessworkflow.api.actions.Action action : actions) {
                currentNode = this.connect(currentNode, this.getActionNode((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, action, outputVar, extraVariables));
            }
            this.connect(currentNode, (NodeFactory<?, ?>)((EndNodeFactory)embeddedSubProcess.endNode(this.parserContext.newId()).name("EmbeddedEnd")).terminate(true)).done();
        } else {
            this.connect((NodeFactory<?, ?>)embeddedSubProcess.startNode(this.parserContext.newId()).name("EmbeddedStart"), (NodeFactory<?, ?>)((EndNodeFactory)embeddedSubProcess.endNode(this.parserContext.newId()).name("EmbeddedEnd")).terminate(true)).done();
        }
        return embeddedSubProcess;
    }

    protected final MakeNodeResult getActionNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, io.serverlessworkflow.api.actions.Action action) {
        return this.getActionNode(embeddedSubProcess, action, null, new String[0]);
    }

    public MakeNodeResult getActionNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, io.serverlessworkflow.api.actions.Action action, String collectVar, String ... extraVariables) {
        ActionDataFilter actionFilter = action.getActionDataFilter();
        String fromExpr = null;
        String resultExpr = null;
        String toExpr = null;
        if (actionFilter != null) {
            fromExpr = actionFilter.getFromStateData();
            resultExpr = actionFilter.getResults();
            toExpr = actionFilter.getToStateData();
        }
        return this.filterAndMergeNode(embeddedSubProcess, fromExpr, resultExpr, toExpr, (factory, inputVar, outputVar) -> this.getActionNode((RuleFlowNodeContainerFactory<?, ?>)factory, action, inputVar, outputVar, collectVar, extraVariables));
    }

    private NodeFactory<?, ?> getActionNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, io.serverlessworkflow.api.actions.Action action, String inputVar, String outputVar, String collectVar, String ... extraVariables) {
        FunctionRef functionRef = action.getFunctionRef();
        JsonNode functionArgs = functionRef.getArguments();
        String actionName = functionRef.getRefName();
        if (this.workflow.getFunctions() == null) {
            throw new IllegalArgumentException("cannot find function " + actionName + " because funtions are not defined");
        }
        FunctionDefinition actionFunction = this.workflow.getFunctions().getFunctionDefs().stream().filter(wf -> wf.getName().equals(actionName)).findFirst().orElseThrow(() -> new IllegalArgumentException("cannot find function " + actionName));
        switch (this.getActionType(actionFunction)) {
            case SCRIPT: {
                return embeddedSubProcess.actionNode(this.parserContext.newId()).name(actionName).action("java", functionRef.getArguments().get("script").asText());
            }
            case EXPRESSION: {
                return embeddedSubProcess.actionNode(this.parserContext.newId()).name(actionName).action((Action)ExpressionActionSupplier.of(this.workflow.getExpressionLang(), actionFunction.getOperation()).withVarNames(inputVar, outputVar).withCollectVar(collectVar).withAddInputVars(extraVariables).build());
            }
            case SYSOUT: {
                return embeddedSubProcess.actionNode(this.parserContext.newId()).name(actionName).action((Action)new SysoutActionSupplier(this.workflow.getExpressionLang(), functionRef.getArguments().get(SYSOUT_TYPE_PARAM).asText(), inputVar, extraVariables));
            }
            case SERVICE: {
                WorkItemNodeFactory serviceFactory = (WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)embeddedSubProcess.workItemNode(this.parserContext.newId()).name(actionName)).metaData("Type", (Object)SERVICE_TASK_TYPE)).workName(SERVICE_TASK_TYPE)).workParameter(WORKITEM_INTERFACE, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_INTERFACE_KEY, this.parserContext.getContext()))).workParameter(WORKITEM_OPERATION, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_OPERATION_KEY, this.parserContext.getContext()))).workParameter(WORKITEM_INTERFACE_IMPL, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_INTERFACE_KEY, this.parserContext.getContext()))).workParameter(WORKITEM_OPERATION_IMPL, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_OPERATION_KEY, this.parserContext.getContext()))).workParameter(SERVICE_IMPL_KEY, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_IMPL_KEY, this.parserContext.getContext(), "Java"))).inMapping(inputVar, WORKITEM_PARAM)).outMapping(WORKITEM_PARAM, outputVar);
                if (functionArgs == null || functionArgs.isEmpty()) {
                    serviceFactory.workParameter(WORKITEM_PARAM_TYPE, (Object)"com.fasterxml.jackson.databind.JsonNode");
                } else {
                    this.processArgs(serviceFactory, functionArgs, WORKITEM_PARAM, ObjectResolver.class);
                }
                return serviceFactory;
            }
            case REST: {
                WorkItemNodeFactory workItemFactory = (WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)embeddedSubProcess.workItemNode(this.parserContext.newId()).name(actionFunction.getName())).metaData("Type", (Object)"Rest")).workName("Rest")).workParameter("Url", (Object)actionFunction.getOperation())).workParameter("Method", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, "method", this.parserContext.getContext()))).workParameter("Username", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, "user", this.parserContext.getContext()))).workParameter("Password", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, "password", this.parserContext.getContext()))).workParameter("Host", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, "host", this.parserContext.getContext()))).workParameter("Port", (Object)ServerlessWorkflowUtils.resolveFunctionMetadataAsInt(actionFunction, "port", this.parserContext.getContext()))).workParameter("BodyBuilder", (Object)new RestBodyBuilderSupplier())).inMapping(inputVar, "ContentData")).outMapping(WORKITEM_RESULT, outputVar);
                if (functionArgs != null && !functionArgs.isEmpty()) {
                    this.processArgs(workItemFactory, functionArgs, "ContentData", ObjectResolver.class);
                }
                return workItemFactory;
            }
            case OPENAPI: {
                return ((WorkItemNodeFactory)((WorkItemNodeFactory)OpenApiTaskDescriptor.builderFor((String)ServerlessWorkflowUtils.getOpenApiURI(actionFunction), (String)ServerlessWorkflowUtils.getOpenApiOperationId(actionFunction)).withExprLang(this.workflow.getExpressionLang()).withModelParameter(WORKITEM_PARAM).withArgs(CompositeContextNodeHandler.functionsToMap(functionArgs), JsonNodeResolver.class, JsonNode.class).build(embeddedSubProcess.workItemNode(this.parserContext.newId())).name(functionRef.getRefName())).inMapping(inputVar, WORKITEM_PARAM)).outMapping(WORKITEM_RESULT, outputVar);
            }
        }
        return this.emptyNode(embeddedSubProcess, actionName);
    }

    private static Map<String, Object> functionsToMap(JsonNode jsonNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jsonNode != null) {
            Iterator iter = jsonNode.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                map.put((String)entry.getKey(), JsonObjectUtils.toJavaValue((JsonNode)((JsonNode)entry.getValue())));
            }
        }
        return map;
    }

    private void processArgs(WorkItemNodeFactory<?> workItemFactory, JsonNode functionArgs, String paramName, Class<? extends ExpressionWorkItemResolver> clazz) {
        CompositeContextNodeHandler.functionsToMap(functionArgs).entrySet().forEach(entry -> this.processArg((Map.Entry<String, Object>)entry, workItemFactory, paramName, clazz));
    }

    private void processArg(Map.Entry<String, Object> entry, WorkItemNodeFactory<?> workItemFactory, String paramName, Class<? extends ExpressionWorkItemResolver> clazz) {
        boolean isExpr = this.isExpression(entry.getValue());
        ((WorkItemNodeFactory)workItemFactory.workParameter(entry.getKey(), AbstractServiceTaskDescriptor.processWorkItemValue((String)this.workflow.getExpressionLang(), (Object)entry.getValue(), (String)paramName, clazz, (boolean)isExpr))).workParameterDefinition(entry.getKey(), DataTypeResolver.fromObject((Object)entry.getValue(), (boolean)isExpr));
    }

    private boolean isExpression(Object expr) {
        return expr instanceof CharSequence && ExpressionHandlerFactory.get((String)this.workflow.getExpressionLang(), (String)expr.toString()).isValid();
    }

    private ActionType getActionType(FunctionDefinition actionFunction) {
        String type;
        if (ServerlessWorkflowUtils.isOpenApiOperation(actionFunction)) {
            return ActionType.OPENAPI;
        }
        if (actionFunction.getType() == FunctionDefinition.Type.EXPRESSION) {
            return ActionType.EXPRESSION;
        }
        String string = type = actionFunction.getMetadata() != null ? (String)actionFunction.getMetadata().get("type") : null;
        if (SERVICE_TYPE.equalsIgnoreCase(type)) {
            return ActionType.SERVICE;
        }
        if ("script".equalsIgnoreCase(type)) {
            return ActionType.SCRIPT;
        }
        if (SYSOUT_TYPE.equalsIgnoreCase(type)) {
            return ActionType.SYSOUT;
        }
        if (REST_TYPE.equalsIgnoreCase(type)) {
            return ActionType.REST;
        }
        return ActionType.EMPTY;
    }

    private NodeFactory<?, ?> emptyNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, String actionName) {
        return embeddedSubProcess.actionNode(this.parserContext.newId()).name(actionName).action("java", "");
    }

    private static enum ActionType {
        REST,
        SERVICE,
        OPENAPI,
        EXPRESSION,
        SCRIPT,
        SYSOUT,
        EMPTY;

    }
}

