/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.suppliers;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import java.util.function.Supplier;
import org.jbpm.compiler.canonical.descriptors.SupplierUtils;
import org.kie.kogito.serverless.workflow.actions.ExpressionAction;
import org.kie.kogito.serverless.workflow.suppliers.SWFSupplierUtils;

public class ExpressionActionSupplier
extends ExpressionAction
implements Supplier<Expression> {
    private final ObjectCreationExpr expression;

    public static Builder of(String lang, String expr) {
        return new Builder(lang, expr);
    }

    private ExpressionActionSupplier(String lang, String expr, String inputVar, String outputVar, String collectVar, String[] addInputVars) {
        super(lang, expr, inputVar, outputVar, collectVar, addInputVars);
        this.expression = SupplierUtils.getExpression(ExpressionAction.class, (String[])SWFSupplierUtils.getVarArgs(lang, expr, inputVar, outputVar, collectVar, addInputVars));
    }

    @Override
    public Expression get() {
        return this.expression;
    }

    public static class Builder {
        private final String lang;
        private final String expr;
        private String inputVar = "workflowdata";
        private String outputVar = "workflowdata";
        private String collectVar;
        private String[] addInputVars = new String[0];

        private Builder(String lang, String expr) {
            this.lang = lang;
            this.expr = expr;
        }

        public Builder withVarNames(String varName) {
            this.inputVar = varName;
            this.outputVar = varName;
            return this;
        }

        public Builder withVarNames(String inputVar, String outputVar) {
            this.inputVar = inputVar;
            this.outputVar = outputVar;
            return this;
        }

        public Builder withCollectVar(String collectVar) {
            this.collectVar = collectVar;
            return this;
        }

        public Builder withAddInputVars(String[] addInputVars) {
            this.addInputVars = addInputVars;
            return this;
        }

        public ExpressionActionSupplier build() {
            return new ExpressionActionSupplier(this.lang, this.expr, this.inputVar, this.outputVar, this.collectVar, this.addInputVars);
        }
    }
}

