/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.workflow.Constants;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.TimerNodeFactory;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.kie.kogito.codegen.api.GeneratedInfo;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.parser.DefaultNodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.NodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandlerFactory;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class ServerlessWorkflowParser {
    public static final String NODE_START_NAME = "Start";
    public static final String NODE_END_NAME = "End";
    public static final String DEFAULT_NAME = "workflow";
    public static final String DEFAULT_PACKAGE = "org.kie.kogito.serverless";
    public static final String DEFAULT_VERSION = "1.0";
    public static final String JSON_NODE = "com.fasterxml.jackson.databind.JsonNode";
    public static final String DEFAULT_WORKFLOW_VAR = "workflowdata";
    private NodeIdGenerator idGenerator = DefaultNodeIdGenerator.get();
    private Workflow workflow;
    private GeneratedInfo<KogitoWorkflowProcess> processInfo;
    private KogitoBuildContext context;

    public static ServerlessWorkflowParser of(Reader workflowFile, String workflowFormat, KogitoBuildContext context) throws IOException {
        return ServerlessWorkflowParser.of((Workflow)ServerlessWorkflowUtils.getObjectMapper(workflowFormat).readValue(workflowFile, Workflow.class), context);
    }

    public static ServerlessWorkflowParser of(Workflow workflow, KogitoBuildContext context) {
        return new ServerlessWorkflowParser(workflow, context);
    }

    public ServerlessWorkflowParser withIdGenerator(NodeIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    private ServerlessWorkflowParser(Workflow workflow, KogitoBuildContext context) {
        this.workflow = workflow;
        this.context = context;
    }

    private GeneratedInfo<KogitoWorkflowProcess> parseProcess() {
        String workflowStartStateName = this.workflow.getStart().getStateName();
        if (workflowStartStateName == null || workflowStartStateName.trim().isEmpty()) {
            throw new IllegalArgumentException("workflow does not define a starting state");
        }
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)this.workflow.getId()).name(this.workflow.getName() == null ? DEFAULT_NAME : this.workflow.getName()).version(this.workflow.getVersion() == null ? DEFAULT_VERSION : this.workflow.getVersion()).packageName(this.workflow.getMetadata() != null ? this.workflow.getMetadata().getOrDefault("package", DEFAULT_PACKAGE) : DEFAULT_PACKAGE).visibility("Public").variable(DEFAULT_WORKFLOW_VAR, (DataType)new ObjectDataType(JsonNode.class), (Object)ObjectMapperFactory.get().createObjectNode());
        ParserContext parserContext = new ParserContext(this.idGenerator, factory, this.context);
        Constants constants = this.workflow.getConstants();
        if (constants != null) {
            factory.metaData("customConstants", (Object)constants.getConstantsDef());
        }
        Collection handlers = this.workflow.getStates().stream().map(state -> StateHandlerFactory.getStateHandler(state, this.workflow, parserContext)).filter(Optional::isPresent).map(Optional::get).filter(state -> !state.usedForCompensation()).collect(Collectors.toList());
        handlers.forEach(StateHandler::handleStart);
        handlers.forEach(StateHandler::handleEnd);
        handlers.forEach(StateHandler::handleState);
        handlers.forEach(StateHandler::handleTransitions);
        handlers.forEach(StateHandler::handleErrors);
        handlers.forEach(StateHandler::handleConnections);
        if (parserContext.isCompensation()) {
            factory.metaData("Compensation", (Object)true);
            factory.addCompensationContext(this.workflow.getId());
        }
        return new GeneratedInfo((Object)factory.validate().getProcess(), parserContext.generatedFiles());
    }

    public GeneratedInfo<KogitoWorkflowProcess> getProcessInfo() {
        if (this.processInfo == null) {
            this.processInfo = this.parseProcess();
        }
        return this.processInfo;
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> SubProcessNodeFactory<T> subprocessNode(SubProcessNodeFactory<T> nodeFactory, String inputVar, String outputVar) {
        Map<String, String> types = Collections.singletonMap(DEFAULT_WORKFLOW_VAR, JSON_NODE);
        DataAssociation inputDa = new DataAssociation(new DataDefinition(inputVar, inputVar, JSON_NODE), new DataDefinition(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR, JSON_NODE), null, null);
        DataAssociation outputDa = new DataAssociation(new DataDefinition(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR, JSON_NODE), new DataDefinition(outputVar, outputVar, JSON_NODE), null, null);
        VariableScope variableScope = new VariableScope();
        return (SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)nodeFactory.independent(true).metaData("BPMN.InputTypes", types)).metaData("BPMN.OutputTypes", types)).mapDataInputAssociation(inputDa)).mapDataOutputAssociation(outputDa)).context((Context)variableScope)).defaultContext((Context)variableScope);
    }

    public static <T extends NodeFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>> T sendEventNode(NodeFactory<T, P> actionNode, EventDefinition eventDefinition, String inputVar) {
        return (T)actionNode.name(eventDefinition.getName()).metaData("EventType", (Object)"message").metaData("MappingVariable", (Object)inputVar).metaData("TriggerRef", (Object)eventDefinition.getType()).metaData("MessageType", (Object)JSON_NODE).metaData("TriggerType", (Object)"ProduceMessage");
    }

    public static <T extends NodeFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>> T messageNode(T nodeFactory, EventDefinition eventDefinition, String inputVar) {
        return (T)nodeFactory.name(eventDefinition.getName()).metaData("EventType", (Object)"message").metaData("TriggerMapping", (Object)inputVar).metaData("TriggerRef", (Object)eventDefinition.getType()).metaData("MessageType", (Object)JSON_NODE).metaData("TriggerType", (Object)"ConsumeMessage").metaData("DataOnly", (Object)ServerlessWorkflowParser.isDataOnly(eventDefinition));
    }

    private static Boolean isDataOnly(EventDefinition eventDefinition) {
        Boolean result = Boolean.TRUE;
        Map metadata = eventDefinition.getMetadata();
        String dataOnlyKey = "dataOnly";
        if (metadata != null && metadata.containsKey("dataOnly")) {
            result = Boolean.parseBoolean((String)metadata.get("dataOnly"));
        }
        return result;
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> SplitFactory<T> eventBasedExclusiveSplitNode(SplitFactory<T> nodeFactory) {
        return (SplitFactory)((SplitFactory)((SplitFactory)nodeFactory.name("ExclusiveSplit_" + nodeFactory.getNode().getId())).type(4).metaData("UniqueId", (Object)Long.toString(nodeFactory.getNode().getId()))).metaData("EventBased", (Object)"true");
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> SplitFactory<T> exclusiveSplitNode(SplitFactory<T> nodeFactory) {
        return (SplitFactory)((SplitFactory)nodeFactory.name("ExclusiveSplit_" + nodeFactory.getNode().getId())).type(2).metaData("UniqueId", (Object)Long.toString(nodeFactory.getNode().getId()));
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> JoinFactory<T> joinExclusiveNode(JoinFactory<T> nodeFactory) {
        return (JoinFactory)nodeFactory.name("ExclusiveJoin_" + nodeFactory.getNode().getId()).type(2).metaData("UniqueId", (Object)Long.toString(nodeFactory.getNode().getId()));
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> TimerNodeFactory<T> timerNode(TimerNodeFactory<T> nodeFactory, String duration) {
        return (TimerNodeFactory)((TimerNodeFactory)((TimerNodeFactory)nodeFactory.name("TimerNode_" + nodeFactory.getNode().getId())).type(1).delay(duration).metaData("UniqueId", (Object)Long.toString(nodeFactory.getNode().getId()))).metaData("EventType", (Object)"Timer");
    }
}

