/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.util.Map;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

enum ActionType {
    REST("rest"),
    SERVICE("service"),
    OPENAPI(new String[0]),
    EXPRESSION(new String[0]),
    SCRIPT("script"),
    SYSOUT("sysout"),
    EMPTY(new String[0]);

    private String[] prefixes;

    private ActionType(String ... prefixes) {
        this.prefixes = prefixes;
    }

    public String getOperation(FunctionDefinition function) {
        String operation = function.getOperation();
        return this.prefixes.length == 0 || operation == null ? operation : this.checkPrefix(operation);
    }

    private String checkPrefix(String operation) {
        for (String prefix : this.prefixes) {
            if (!operation.startsWith(prefix)) continue;
            return operation.substring(operation.length() > prefix.length() && operation.charAt(prefix.length()) == ':' ? prefix.length() + 1 : prefix.length());
        }
        return operation;
    }

    public static ActionType from(FunctionDefinition actionFunction) {
        switch (actionFunction.getType()) {
            case REST: {
                return ServerlessWorkflowUtils.isOpenApiOperation(actionFunction) ? OPENAPI : ActionType.fromMetadata(actionFunction.getMetadata());
            }
            case EXPRESSION: {
                return EXPRESSION;
            }
            case CUSTOM: {
                return ActionType.fromOperation(actionFunction.getOperation());
            }
        }
        throw new UnsupportedOperationException(actionFunction.getType() + " is not supported yet");
    }

    private static ActionType fromOperation(String operation) {
        for (ActionType value : ActionType.values()) {
            for (String prefix : value.prefixes) {
                if (!operation.startsWith(prefix)) continue;
                return value;
            }
        }
        throw new UnsupportedOperationException("Unable to recognize custom format " + operation + ", supported custom formats are " + ActionType.values());
    }

    private static ActionType fromMetadata(Map<String, String> metadata) {
        String type;
        String string = type = metadata != null ? metadata.get("type") : null;
        if (type != null) {
            try {
                return ActionType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return EMPTY;
    }
}

