/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.datainputschema.DataInputSchema;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.error.ErrorDefinition;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.filters.EventDataFilter;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.transitions.Transition;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.BoundaryEventNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.EventNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SupportsAction;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.ServerlessWorkflowParser;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.suppliers.CollectorActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.CompensationActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.DataInputSchemaActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ExpressionActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.MergeActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ProduceEventActionSupplier;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public abstract class StateHandler<S extends State> {
    protected final S state;
    protected final Workflow workflow;
    protected final ParserContext parserContext;
    private NodeFactory<?, ?> startNodeFactory;
    private EndNodeFactory<?> endNodeFactory;
    private NodeFactory<?, ?> node;
    private NodeFactory<?, ?> outgoingNode;
    protected final boolean isStartState;
    private JoinFactory<?> join;
    private List<Long> incomingConnections = new ArrayList<Long>();

    protected StateHandler(S state, Workflow workflow, ParserContext parserContext) {
        this.workflow = workflow;
        this.state = state;
        this.parserContext = parserContext;
        this.isStartState = state.getName().equals(workflow.getStart().getStateName());
    }

    public boolean usedForCompensation() {
        return false;
    }

    public void handleStart() {
        if (this.isStartState) {
            RuleFlowProcessFactory factory = this.parserContext.factory();
            this.startNodeFactory = this.parserContext.factory().startNode(this.parserContext.newId()).name("Start");
            DataInputSchema inputSchema = this.workflow.getDataInputSchema();
            if (inputSchema != null) {
                ServerlessWorkflowUtils.processResourceFile(URI.create(inputSchema.getSchema()), this.parserContext);
                this.startNodeFactory = this.connect(this.startNodeFactory, (NodeFactory<?, ?>)factory.actionNode(this.parserContext.newId()).action((Action)new DataInputSchemaActionSupplier(inputSchema.getSchema(), inputSchema.isFailOnValidationErrors())));
            }
            this.startNodeFactory.done();
        }
    }

    public void handleEnd() {
        if (this.state.getEnd() != null) {
            this.endNodeFactory = (EndNodeFactory)this.endNodeFactory((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory(), this.state.getEnd().getProduceEvents()).name("End");
            this.endNodeFactory.done();
        }
    }

    protected final <T extends NodeFactory<?, ?>> NodeFactory<?, ?> sendEventNode(T actionNode, ProduceEvent event) {
        return this.sendEventNode(actionNode, this.eventDefinition(event.getEventRef()), event.getData(), "workflowdata");
    }

    protected final <T extends NodeFactory<?, ?>> NodeFactory<?, ?> sendEventNode(T actionNode, EventDefinition eventDefinition, String data, String defaultWorkflowVar) {
        return ServerlessWorkflowParser.sendEventNode(((SupportsAction)actionNode).action((Action)new ProduceEventActionSupplier(this.workflow, data)), eventDefinition, defaultWorkflowVar);
    }

    private void handleCompensation(RuleFlowNodeContainerFactory<?, ?> factory) {
        StateHandler<?> compensation = this.parserContext.getStateHandler(this.state.getCompensatedBy());
        if (compensation == null) {
            throw new IllegalArgumentException("State " + this.getState().getName() + " refers to a compensation " + this.state.getCompensatedBy() + " which cannot be found");
        }
        this.parserContext.setCompensation();
        long eventCompensationId = this.parserContext.newId();
        long subprocessCompensationId = this.parserContext.newId();
        long startCompensationId = this.parserContext.newId();
        String uniqueId = (String)this.outgoingNode.getNode().getMetaData().get("UniqueId");
        factory.boundaryEventNode(eventCompensationId).addCompensationHandler(uniqueId).attachedTo(uniqueId).eventType("Compensation").metaData("EventType", (Object)"compensation");
        CompositeContextNodeFactory embeddedSubProcess = (CompositeContextNodeFactory)((CompositeContextNodeFactory)((CompositeContextNodeFactory)factory.compositeContextNode(subprocessCompensationId).autoComplete(true)).metaData("isForCompensation", (Object)true)).startNode(startCompensationId).interrupting(true).done();
        factory.association(eventCompensationId, subprocessCompensationId, null);
        long lastNodeId = this.handleCompensation((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, compensation);
        embeddedSubProcess.connection(startCompensationId, lastNodeId);
        compensation = this.parserContext.getStateHandler(compensation);
        while (compensation != null) {
            if (!compensation.usedForCompensation()) {
                throw new IllegalArgumentException("compensation node can only have transition to other compensation node. Node " + compensation.getState().getName() + " is not used for compensation");
            }
            lastNodeId = this.handleCompensation((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, compensation);
            compensation = this.parserContext.getStateHandler(compensation);
        }
        long endCompensationId = this.parserContext.newId();
        ((CompositeContextNodeFactory)embeddedSubProcess.endNode(endCompensationId).terminate(false).done()).connection(lastNodeId, endCompensationId);
    }

    private long handleCompensation(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, StateHandler<?> compensation) {
        if (compensation.getState().getCompensatedBy() != null) {
            throw new IllegalArgumentException("Serverless workflow specification forbids nested compensations, hence state " + compensation.getState().getName() + " is not valid");
        }
        compensation.handleState(embeddedSubProcess);
        Transition transition = compensation.getState().getTransition();
        long lastNodeId = compensation.getNode().getNode().getId();
        compensation.handleTransitions(embeddedSubProcess, transition, lastNodeId);
        compensation.handleErrors(embeddedSubProcess);
        compensation.handleConnections(embeddedSubProcess);
        return lastNodeId;
    }

    public void handleState() {
        this.handleState((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory());
    }

    protected void handleState(RuleFlowNodeContainerFactory<?, ?> factory) {
        MakeNodeResult result = this.makeNode(factory);
        this.node = result.getIncomingNode();
        this.outgoingNode = result.getOutgoingNode();
        if (this.state.getCompensatedBy() != null) {
            this.handleCompensation(factory);
        }
        this.node.done();
        this.outgoingNode.done();
        StateDataFilter stateFilter = this.state.getStateDataFilter();
        if (stateFilter != null) {
            String output;
            String input = stateFilter.getInput();
            if (input != null) {
                ActionNodeFactory<?> actionNode = this.handleStateFilter(factory, input);
                factory.connection(actionNode.getNode().getId(), this.node.getNode().getId());
                this.node = actionNode;
            }
            if ((output = stateFilter.getOutput()) != null) {
                ActionNodeFactory<?> actionNode = this.handleStateFilter(factory, output);
                factory.connection(this.outgoingNode.getNode().getId(), actionNode.getNode().getId());
                this.outgoingNode = actionNode;
            }
        }
        this.connectStart(factory);
        this.connectEnd(factory);
    }

    private ActionNodeFactory<?> handleStateFilter(RuleFlowNodeContainerFactory<?, ?> factory, String filter) {
        ActionNodeFactory result = factory.actionNode(this.parserContext.newId()).action((Action)ExpressionActionSupplier.of(this.workflow, filter).build());
        result.done();
        return result;
    }

    public void connect(RuleFlowNodeContainerFactory<?, ?> factory, long sourceId) {
        this.incomingConnections.add(sourceId);
    }

    public void handleConnections() {
        this.handleConnections((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory());
    }

    protected void handleConnections(RuleFlowNodeContainerFactory<?, ?> factory) {
        NodeFactory<?, ?> incoming = this.getIncomingNode(factory);
        for (long sourceId : this.incomingConnections) {
            factory.connection(sourceId, incoming.getNode().getId());
        }
    }

    public void handleErrors() {
        this.handleErrors((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory());
    }

    protected final Iterable<ErrorDefinition> getErrorDefinitions(Error error) {
        Predicate<ErrorDefinition> pred;
        if (error.getErrorRef() != null) {
            pred = e -> error.getErrorRef().equals(e.getName());
        } else if (error.getErrorRefs() != null) {
            pred = e -> error.getErrorRefs().contains(e.getName());
        } else {
            throw new IllegalStateException("errorRef or errorRefs should be defined in list of error definitions");
        }
        return this.workflow.getErrors().getErrorDefs().stream().filter(pred).collect(Collectors.toList());
    }

    protected void handleErrors(RuleFlowNodeContainerFactory<?, ?> factory) {
        for (Error error : this.state.getOnErrors()) {
            for (ErrorDefinition errorDef : this.getErrorDefinitions(error)) {
                String eventType = "Error-" + this.node.getNode().getMetaData().get("UniqueId");
                BoundaryEventNodeFactory boundaryNode = (BoundaryEventNodeFactory)((BoundaryEventNodeFactory)factory.boundaryEventNode(this.parserContext.newId()).attachedTo(this.node.getNode().getId()).metaData("EventType", (Object)"error")).metaData("HasErrorEvent", (Object)true);
                if (errorDef.getCode() != null) {
                    boundaryNode.metaData("ErrorEvent", (Object)errorDef.getCode());
                    eventType = eventType + "-" + errorDef.getCode();
                }
                boundaryNode.eventType(eventType).name("Error-" + this.node.getNode().getName() + "-" + errorDef.getCode());
                factory.exceptionHandler(eventType, errorDef.getCode());
                if (error.getEnd() != null) {
                    this.connect((NodeFactory<?, ?>)boundaryNode, (NodeFactory<?, ?>)this.endNodeFactory(factory, error.getEnd().getProduceEvents()));
                    continue;
                }
                this.handleTransitions(factory, error.getTransition(), boundaryNode.getNode().getId());
            }
        }
    }

    public void handleTransitions() {
        this.handleTransitions((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory(), this.state.getTransition(), this.outgoingNode.getNode().getId());
    }

    protected void handleTransitions(RuleFlowNodeContainerFactory<?, ?> factory, Transition transition, long sourceId) {
        this.handleTransition(factory, transition, sourceId, Optional.empty());
    }

    private void connectStart(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.startNodeFactory != null) {
            factory.connection(this.startNodeFactory.getNode().getId(), this.node.getNode().getId());
        }
    }

    private void connectEnd(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.endNodeFactory != null) {
            if (this.state.getEnd().isCompensate()) {
                this.endNodeFactory.done().connection(this.compensationEvent(factory, this.outgoingNode.getNode().getId()), this.endNodeFactory.getNode().getId());
            } else {
                factory.connection(this.outgoingNode.getNode().getId(), this.endNodeFactory.getNode().getId());
            }
        }
    }

    public final NodeFactory<?, ?> getNode() {
        return this.node;
    }

    public S getState() {
        return this.state;
    }

    public NodeFactory<?, ?> getIncomingNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.join != null) {
            return this.join;
        }
        if (this.incomingConnections.size() > 1) {
            this.join = factory.joinNode(this.parserContext.newId()).type(5).name("Join-" + this.node.getNode().getName());
            this.join.done().connection(this.join.getNode().getId(), this.node.getNode().getId());
            return this.join;
        }
        return this.getNode();
    }

    protected abstract MakeNodeResult makeNode(RuleFlowNodeContainerFactory<?, ?> var1);

    protected final void handleTransition(RuleFlowNodeContainerFactory<?, ?> factory, Transition transition, long sourceId, Optional<HandleTransitionCallBack> callback) {
        StateHandler<?> targetState = this.parserContext.getStateHandler(transition);
        if (targetState != null) {
            List produceEvents = transition.getProduceEvents();
            if (produceEvents.isEmpty()) {
                if (transition.isCompensate()) {
                    long eventId = this.compensationEvent(factory, sourceId);
                    targetState.connect(factory, eventId);
                    callback.ifPresent(c -> c.onIdTarget(eventId));
                } else {
                    targetState.connect(factory, sourceId);
                    callback.ifPresent(c -> c.onStateTarget(targetState));
                }
            } else {
                ActionNodeFactory actionNode = factory.actionNode(this.parserContext.newId());
                NodeFactory<?, ?> endNode = this.handleProduceEvents(factory, actionNode, produceEvents);
                factory.connection(sourceId, actionNode.getNode().getId());
                if (transition.isCompensate()) {
                    long eventId = this.compensationEvent(factory, sourceId);
                    callback.ifPresent(c -> c.onIdTarget(eventId));
                } else {
                    callback.ifPresent(c -> c.onIdTarget(actionNode.getNode().getId()));
                }
                targetState.connect(factory, endNode.getNode().getId());
            }
        } else {
            callback.ifPresent(HandleTransitionCallBack::onEmptyTarget);
        }
    }

    private <T extends NodeFactory<?, ?>> NodeFactory<?, ?> handleProduceEvents(RuleFlowNodeContainerFactory<?, ?> factory, T startNode, List<ProduceEvent> produceEvents) {
        Object endNode = startNode;
        this.sendEventNode(startNode, produceEvents.get(0));
        if (produceEvents.size() > 1) {
            ListIterator<ProduceEvent> iter = produceEvents.listIterator(1);
            while (iter.hasNext()) {
                endNode = this.connect((NodeFactory<?, ?>)endNode, this.sendEventNode(factory.actionNode(this.parserContext.newId()), iter.next()));
            }
        }
        return endNode;
    }

    protected final String getVarName() {
        return this.state.getName() + "_" + this.parserContext.newId();
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, EventDataFilter eventFilter, FilterableNodeSupplier nodeSupplier) {
        return this.filterAndMergeNode(embeddedSubProcess, eventFilter, this.getVarName(), nodeSupplier);
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, EventDataFilter eventFilter, String varName, FilterableNodeSupplier nodeSupplier) {
        String dataExpr = null;
        String toExpr = null;
        boolean useData = true;
        if (eventFilter != null) {
            dataExpr = eventFilter.getData();
            toExpr = eventFilter.getToStateData();
            useData = eventFilter.isUseData();
        }
        return this.filterAndMergeNode(embeddedSubProcess, varName, null, dataExpr, toExpr, useData, nodeSupplier);
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, String fromStateExpr, String resultExpr, String toStateExpr, boolean shouldMerge, FilterableNodeSupplier nodeSupplier) {
        return this.filterAndMergeNode(embeddedSubProcess, this.getVarName(), fromStateExpr, resultExpr, toStateExpr, shouldMerge, nodeSupplier);
    }

    protected boolean isTempVariable(String varName) {
        return !varName.equals("workflowdata");
    }

    private final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, String actionVarName, String fromStateExpr, String resultExpr, String toStateExpr, boolean shouldMerge, FilterableNodeSupplier nodeSupplier) {
        NodeFactory<?, ?> currentNode;
        NodeFactory<?, ?> startNode;
        if (this.isTempVariable(actionVarName)) {
            embeddedSubProcess.variable(actionVarName, (DataType)new ObjectDataType(JsonNode.class.getCanonicalName()), "customTags", (Object)"internal");
        }
        if (fromStateExpr != null) {
            startNode = embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)ExpressionActionSupplier.of(this.workflow, fromStateExpr).withVarNames("workflowdata", actionVarName).build());
            currentNode = this.connect(startNode, nodeSupplier.apply(embeddedSubProcess, actionVarName, actionVarName));
        } else {
            startNode = currentNode = nodeSupplier.apply(embeddedSubProcess, "workflowdata", actionVarName);
        }
        if (shouldMerge) {
            if (resultExpr != null) {
                currentNode = this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)ExpressionActionSupplier.of(this.workflow, resultExpr).withVarNames(actionVarName, actionVarName).build()));
            }
            currentNode = toStateExpr != null ? this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)new CollectorActionSupplier(this.workflow.getExpressionLang(), toStateExpr, "workflowdata", actionVarName))) : this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)new MergeActionSupplier(actionVarName, "workflowdata")));
        }
        currentNode.done();
        return new MakeNodeResult(startNode, currentNode);
    }

    protected final NodeFactory<?, ?> connect(NodeFactory<?, ?> currentNode, NodeFactory<?, ?> nodeFactory) {
        currentNode.done().connection(currentNode.getNode().getId(), nodeFactory.getNode().getId());
        return nodeFactory;
    }

    protected final NodeFactory<?, ?> connect(NodeFactory<?, ?> currentNode, MakeNodeResult twoNodes) {
        this.connect(currentNode, twoNodes.getIncomingNode()).done();
        return twoNodes.getOutgoingNode();
    }

    protected final NodeFactory<?, ?> consumeEventNode(RuleFlowNodeContainerFactory<?, ?> factory, String eventRef, String inputVar, String outputVar) {
        EventDefinition eventDefinition = this.eventDefinition(eventRef);
        return ((EventNodeFactory)((EventNodeFactory)((EventNodeFactory)ServerlessWorkflowParser.messageNode(factory.eventNode(this.parserContext.newId()), eventDefinition, inputVar).inputVariableName(inputVar)).variableName(outputVar)).outMapping(inputVar, outputVar)).eventType("Message-" + eventDefinition.getType());
    }

    protected final EventDefinition eventDefinition(String eventName) {
        return this.workflow.getEvents().getEventDefs().stream().filter(wt -> wt.getName().equals(eventName)).findFirst().orElseThrow(() -> new NoSuchElementException("No event for " + eventName));
    }

    protected EndNodeFactory<?> endNodeFactory(RuleFlowNodeContainerFactory<?, ?> factory, List<ProduceEvent> produceEvents) {
        EndNodeFactory nodeFactory = factory.endNode(this.parserContext.newId());
        if (produceEvents != null && !produceEvents.isEmpty()) {
            this.sendEventNode(nodeFactory, produceEvents.get(0));
        }
        return nodeFactory;
    }

    private long compensationEvent(RuleFlowNodeContainerFactory<?, ?> factory, long sourceId) {
        long eventId = this.parserContext.newId();
        factory.actionNode(eventId).name(this.state.getName() + "-" + eventId).action((Action)new CompensationActionSupplier("implicit:" + this.workflow.getId())).done().connection(sourceId, eventId);
        return eventId;
    }

    protected static interface HandleTransitionCallBack {
        public void onStateTarget(StateHandler<?> var1);

        public void onIdTarget(long var1);

        public void onEmptyTarget();
    }

    @FunctionalInterface
    protected static interface FilterableNodeSupplier {
        public NodeFactory<?, ?> apply(RuleFlowNodeContainerFactory<?, ?> var1, String var2, String var3);
    }
}

