/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.defaultdef.DefaultConditionDefinition;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.states.SwitchState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.api.transitions.Transition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.TimerNodeFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.ServerlessWorkflowParser;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.validation.SwitchValidator;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;
import org.kie.kogito.serverless.workflow.utils.TimeoutsConfigResolver;

public class SwitchHandler
extends StateHandler<SwitchState> {
    private static final String XORSPLITDEFAULT = "Default";
    private List<Runnable> targetHandlers = new ArrayList<Runnable>();

    protected SwitchHandler(SwitchState state, Workflow workflow, ParserContext parserContext) {
        super(state, workflow, parserContext);
    }

    @Override
    public boolean usedForCompensation() {
        return ((SwitchState)this.state).isUsedForCompensation();
    }

    @Override
    public MakeNodeResult makeNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        SwitchValidator.validateConditions((SwitchState)this.state, this.workflow);
        SplitFactory splitFactory = this.isDataBased() ? (SplitFactory)ServerlessWorkflowParser.exclusiveSplitNode(factory.splitNode(this.parserContext.newId())).name(((SwitchState)this.state).getName()) : (SplitFactory)ServerlessWorkflowParser.eventBasedExclusiveSplitNode(factory.splitNode(this.parserContext.newId())).name(((SwitchState)this.state).getName());
        return new MakeNodeResult((NodeFactory<?, ?>)splitFactory);
    }

    @Override
    protected void handleTransitions(RuleFlowNodeContainerFactory<?, ?> factory, Transition transition, long sourceId) {
        super.handleTransitions(factory, transition, sourceId);
        if (this.isDataBased()) {
            this.finalizeDataBasedSwitchState(factory);
        } else {
            this.finalizeEventBasedSwitchState(factory);
        }
    }

    private boolean isDataBased() {
        return !((SwitchState)this.state).getDataConditions().isEmpty();
    }

    private void finalizeEventBasedSwitchState(RuleFlowNodeContainerFactory<?, ?> factory) {
        NodeFactory<?, ?> splitNode = this.getNode();
        List conditions = ((SwitchState)this.state).getEventConditions();
        DefaultConditionDefinition defaultCondition = ((SwitchState)this.state).getDefaultCondition();
        if (defaultCondition != null) {
            SwitchValidator.validateDefaultCondition(defaultCondition, (SwitchState)this.state, this.workflow, this.parserContext);
            String eventTimeout = TimeoutsConfigResolver.resolveEventTimeout(this.state, this.workflow);
            TimerNodeFactory eventTimeoutTimerNode = ServerlessWorkflowParser.timerNode(factory.timerNode(this.parserContext.newId()), eventTimeout);
            this.connect(splitNode, (NodeFactory<?, ?>)eventTimeoutTimerNode);
            Transition transition = defaultCondition.getTransition();
            if (transition != null) {
                StateHandler<?> targetState = this.parserContext.getStateHandler(transition);
                targetState.connect(factory, eventTimeoutTimerNode.getNode().getId());
            } else {
                this.endIt(eventTimeoutTimerNode.getNode().getId(), factory, defaultCondition.getEnd().getProduceEvents());
            }
        }
        for (EventCondition eventCondition : conditions) {
            StateHandler<?> targetState = this.parserContext.getStateHandler(eventCondition.getTransition());
            MakeNodeResult eventNode = this.filterAndMergeNode(factory, eventCondition.getEventDataFilter(), (f, inputVar, outputVar) -> this.consumeEventNode(f, eventCondition.getEventRef(), inputVar, outputVar));
            factory.connection(splitNode.getNode().getId(), eventNode.getIncomingNode().getNode().getId());
            targetState.connect(factory, eventNode.getOutgoingNode().getNode().getId());
        }
    }

    private void finalizeDataBasedSwitchState(final RuleFlowNodeContainerFactory<?, ?> factory) {
        final NodeFactory<?, ?> startNode = this.getNode();
        final long splitId = startNode.getNode().getId();
        DefaultConditionDefinition defaultCondition = ((SwitchState)this.state).getDefaultCondition();
        if (defaultCondition != null) {
            SwitchValidator.validateDefaultCondition(defaultCondition, (SwitchState)this.state, this.workflow, this.parserContext);
            Transition transition = defaultCondition.getTransition();
            if (transition != null) {
                StateHandler<?> stateHandler = this.parserContext.getStateHandler(transition);
                startNode.metaData(XORSPLITDEFAULT, (Object)SwitchHandler.concatId(splitId, stateHandler.getNode().getNode().getId()));
            } else {
                EndNodeFactory<?> endNodeFactory = this.endIt(splitId, factory, defaultCondition.getEnd().getProduceEvents());
                startNode.metaData(XORSPLITDEFAULT, (Object)SwitchHandler.concatId(splitId, endNodeFactory.getNode().getId()));
            }
        }
        List conditions = ((SwitchState)this.state).getDataConditions();
        for (final DataCondition condition : conditions) {
            this.handleTransition(factory, condition.getTransition(), splitId, Optional.of(new StateHandler.HandleTransitionCallBack(){

                @Override
                public void onStateTarget(StateHandler<?> targetState) {
                    SwitchHandler.this.targetHandlers.add(() -> SwitchHandler.this.addConstraint(factory, startNode, targetState, condition));
                }

                @Override
                public void onIdTarget(long targetId) {
                    SwitchHandler.this.addConstraint(startNode, targetId, condition);
                }

                @Override
                public void onEmptyTarget() {
                    if (condition.getEnd() == null) {
                        throw new IllegalArgumentException("Invalid condition, not transition not end");
                    }
                    EndNodeFactory<?> endNodeFactory = SwitchHandler.this.endIt(splitId, factory, condition.getEnd().getProduceEvents());
                    SwitchHandler.this.addConstraint(startNode, endNodeFactory.getNode().getId(), condition);
                }
            }));
        }
    }

    private EndNodeFactory<?> endIt(long sourceNodeId, RuleFlowNodeContainerFactory<?, ?> factory, List<ProduceEvent> produceEvents) {
        EndNodeFactory<?> endNodeFactory = this.endNodeFactory(factory, produceEvents);
        endNodeFactory.done().connection(sourceNodeId, endNodeFactory.getNode().getId());
        return endNodeFactory;
    }

    private void addConstraint(RuleFlowNodeContainerFactory<?, ?> factory, NodeFactory<?, ?> startNode, StateHandler<?> stateHandler, DataCondition condition) {
        this.addConstraint(startNode, stateHandler.getIncomingNode(factory).getNode().getId(), condition);
    }

    private void addConstraint(NodeFactory<?, ?> startNode, long targetId, DataCondition condition) {
        ((SplitFactory)startNode).constraintBuilder(targetId, SwitchHandler.concatId(startNode.getNode().getId(), targetId), "DROOLS_DEFAULT", this.workflow.getExpressionLang(), ExpressionHandlerUtils.replaceExpr((Workflow)this.workflow, (String)condition.getCondition())).withDefault(SwitchHandler.isDefaultCondition((SwitchState)this.state, condition)).metadata("Variable", (Object)"workflowdata");
    }

    private static String concatId(long start, long end) {
        return start + "_" + end;
    }

    private static boolean isDefaultCondition(SwitchState switchState, DataCondition condition) {
        return switchState.getDefaultCondition() != null && (switchState.getDefaultCondition().getTransition() != null && condition.getTransition() != null && condition.getTransition().getNextState().equals(switchState.getDefaultCondition().getTransition().getNextState()) || switchState.getDefaultCondition().getEnd() != null && condition.getEnd() != null);
    }

    @Override
    public void connect(RuleFlowNodeContainerFactory<?, ?> factory, long sourceId) {
        factory.connection(sourceId, this.getNode().getNode().getId());
    }

    @Override
    public void handleConnections() {
        this.targetHandlers.forEach(Runnable::run);
    }
}

