/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.mapper.BaseObjectMapper;
import io.serverlessworkflow.api.mapper.JsonObjectMapper;
import io.serverlessworkflow.api.mapper.YamlObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerlessWorkflowUtils {
    private static final Logger logger = LoggerFactory.getLogger(ServerlessWorkflowUtils.class);
    public static final String DEFAULT_WORKFLOW_FORMAT = "json";
    public static final String ALTERNATE_WORKFLOW_FORMAT = "yml";
    private static final String APP_PROPERTIES_BASE = "kogito.sw.";
    private static final String APP_PROPERTIES_FUNCTIONS_BASE = "functions.";
    private static final String APP_PROPERTIES_STATES_BASE = "states.";
    public static final String OPENAPI_OPERATION_SEPARATOR = "#";

    private ServerlessWorkflowUtils() {
    }

    public static BaseObjectMapper getObjectMapper(String workflowFormat) {
        return ALTERNATE_WORKFLOW_FORMAT.equals(workflowFormat) ? new YamlObjectMapper() : new JsonObjectMapper();
    }

    public static String resolveFunctionMetadata(FunctionDefinition function, String metadataKey, KogitoBuildContext context) {
        return ServerlessWorkflowUtils.resolveFunctionMetadata(function, metadataKey, context, "");
    }

    public static Integer resolveFunctionMetadataAsInt(FunctionDefinition function, String metadataKey, KogitoBuildContext context) {
        String value = ServerlessWorkflowUtils.resolveFunctionMetadata(function, metadataKey, context);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            logger.warn("Error converting {} to number", (Object)value, (Object)ex);
            return null;
        }
    }

    public static String getForEachVarName(KogitoBuildContext context) {
        return context.getApplicationProperty("kogito.sw.states.foreach.outputVarName").orElse("_swf_eval_temp");
    }

    public static String resolveFunctionMetadata(FunctionDefinition function, String metadataKey, KogitoBuildContext context, String defaultValue) {
        if (function != null) {
            if (function.getMetadata() != null && function.getMetadata().containsKey(metadataKey)) {
                return (String)function.getMetadata().get(metadataKey);
            }
            Optional propValue = context.getApplicationProperty("kogito.sw.functions." + function.getName() + "." + metadataKey);
            if (propValue.isPresent()) {
                return (String)propValue.get();
            }
        }
        logger.warn("Could not resolve function metadata: {}", (Object)metadataKey);
        return defaultValue;
    }

    public static String getOpenApiURI(FunctionDefinition function) {
        return ServerlessWorkflowUtils.isOpenApiOperation(function) ? function.getOperation().substring(0, function.getOperation().indexOf(OPENAPI_OPERATION_SEPARATOR)) : "";
    }

    public static String getOpenApiOperationId(FunctionDefinition function) {
        String uri = ServerlessWorkflowUtils.getOpenApiURI(function);
        return uri.isEmpty() ? uri : function.getOperation().substring(uri.length() + 1);
    }

    public static boolean isOpenApiOperation(FunctionDefinition function) {
        return function.getType() == FunctionDefinition.Type.REST && function.getOperation() != null && function.getOperation().contains(OPENAPI_OPERATION_SEPARATOR);
    }

    public static void processResourceFile(URI uri, ParserContext context) {
        URIContentLoader contentLoader = URIContentLoaderFactory.buildLoader((URI)uri, (ClassLoader)context.getContext().getClassLoader());
        try {
            context.addGeneratedFile(new GeneratedFile(GeneratedFileType.INTERNAL_RESOURCE, uri.getPath(), contentLoader.toBytes()));
        }
        catch (IOException io) {
            logger.warn("Resource {} cannot be found at build time, ignoring", (Object)uri, (Object)io);
        }
    }
}

