/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandler;

public class FunctionTypeHandlerFactory {
    private static final FunctionTypeHandlerFactory INSTANCE = new FunctionTypeHandlerFactory();
    private static final String CUSTOM_TYPE_SEPARATOR = ":";
    private final Map<String, FunctionTypeHandler> typeMap = new HashMap<String, FunctionTypeHandler>();
    private final Map<String, FunctionTypeHandler> customMap = new HashMap<String, FunctionTypeHandler>();

    public static FunctionTypeHandlerFactory instance() {
        return INSTANCE;
    }

    public Optional<FunctionTypeHandler> getTypeHandler(FunctionDefinition functionDef) {
        boolean isCustom = functionDef.getType() == FunctionDefinition.Type.CUSTOM;
        return Optional.ofNullable(this.getMap(isCustom).get(isCustom ? FunctionTypeHandlerFactory.getTypeFromOperation(functionDef) : functionDef.getType().toString()));
    }

    private static String getTypeFromOperation(FunctionDefinition functionDef) {
        String operation = functionDef.getOperation();
        int indexOf = operation.indexOf(CUSTOM_TYPE_SEPARATOR);
        return indexOf == -1 ? operation : operation.substring(0, indexOf);
    }

    public static String trimCustomOperation(FunctionDefinition functionDef) {
        String operation = functionDef.getOperation();
        int indexOf = operation.indexOf(CUSTOM_TYPE_SEPARATOR);
        return indexOf == -1 ? operation : operation.substring(indexOf + 1);
    }

    private Map<String, FunctionTypeHandler> getMap(boolean isCustom) {
        return isCustom ? this.customMap : this.typeMap;
    }

    private FunctionTypeHandlerFactory() {
        ServiceLoader.load(FunctionTypeHandler.class).forEach(handler -> this.getMap(handler.isCustom()).put(handler.type(), (FunctionTypeHandler)handler));
    }
}

