/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import io.serverlessworkflow.api.transitions.Transition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.codegen.common.GeneratedFile;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationIdFactory;
import org.kie.kogito.serverless.workflow.parser.NodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;

public class ParserContext {
    private final Map<String, StateHandler<?>> stateHandlers = new LinkedHashMap();
    private final RuleFlowProcessFactory factory;
    private final NodeIdGenerator idGenerator;
    private final WorkflowOperationIdFactory operationIdFactory;
    private final KogitoBuildContext context;
    private final Collection<GeneratedFile> generatedFiles;
    private boolean isCompensation;

    public ParserContext(NodeIdGenerator idGenerator, RuleFlowProcessFactory factory, KogitoBuildContext context, WorkflowOperationIdFactory operationIdFactory) {
        this.idGenerator = idGenerator;
        this.factory = factory;
        this.context = context;
        this.operationIdFactory = operationIdFactory;
        this.generatedFiles = new ArrayList<GeneratedFile>();
    }

    public void add(StateHandler<?> stateHandler) {
        this.stateHandlers.put(stateHandler.getState().getName(), stateHandler);
    }

    public StateHandler<?> getStateHandler(StateHandler<?> stateHandler) {
        return this.getStateHandler(stateHandler.getState().getTransition());
    }

    public void addGeneratedFile(GeneratedFile file) {
        this.generatedFiles.add(file);
    }

    public Collection<GeneratedFile> generatedFiles() {
        return this.generatedFiles;
    }

    public StateHandler<?> getStateHandler(Transition transition) {
        return transition != null ? this.getStateHandler(transition.getNextState()) : null;
    }

    public StateHandler<?> getStateHandler(String name) {
        return name != null ? this.stateHandlers.get(name) : null;
    }

    public long newId() {
        return this.idGenerator.getId();
    }

    public RuleFlowProcessFactory factory() {
        return this.factory;
    }

    public WorkflowOperationIdFactory operationIdFactory() {
        return this.operationIdFactory;
    }

    public boolean isCompensation() {
        return this.isCompensation;
    }

    public void setCompensation() {
        this.isCompensation = true;
    }

    public KogitoBuildContext getContext() {
        return this.context;
    }
}

