/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.util.Map;
import java.util.function.Function;
import org.kie.kogito.serverless.workflow.parser.handlers.ActionResource;

public class ActionResourceFactory {
    private static final Map<FunctionDefinition.Type, Function<String, ActionResource>> map = Map.of(FunctionDefinition.Type.REST, ActionResourceFactory::justOperation, FunctionDefinition.Type.RPC, ActionResourceFactory::withService);

    private static ActionResource justOperation(String operationStr) {
        String[] tokens = ActionResourceFactory.getTokens(operationStr, 2);
        return new ActionResource(tokens[0], tokens[1], null);
    }

    private static ActionResource withService(String operationStr) {
        String[] tokens = ActionResourceFactory.getTokens(operationStr, 3);
        return new ActionResource(tokens[0], tokens[2], tokens[1]);
    }

    private static String[] getTokens(String operationStr, int expectedTokens) {
        String[] tokens = operationStr.split("#");
        if (tokens.length != expectedTokens) {
            throw new IllegalArgumentException(String.format("%s should have just %d %s", operationStr, expectedTokens - 1, "#"));
        }
        return tokens;
    }

    public static ActionResource getActionResource(FunctionDefinition function) {
        Function<String, ActionResource> factory = map.get(function.getType());
        if (factory == null) {
            throw new UnsupportedOperationException(function.getType() + " does not support action resources");
        }
        return factory.apply(function.getOperation());
    }

    private ActionResourceFactory() {
    }
}

