/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers.openapi;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OpenAPIDescriptor {
    private final HttpMethod method;
    private final String path;
    private final Collection<SecurityScheme> schemes;
    private final Set<String> pathParams = new HashSet<String>();
    private final Set<String> queryParams = new HashSet<String>();
    private final Set<String> headerParams = new HashSet<String>();

    OpenAPIDescriptor(HttpMethod method, String path, Operation operation, Collection<SecurityScheme> schemes) {
        this.method = method;
        this.path = path;
        this.schemes = schemes;
        if (operation.getParameters() != null) {
            operation.getParameters().forEach(this::addParameter);
        }
    }

    private void addParameter(Parameter parameter) {
        switch (parameter.getIn()) {
            case "query": {
                this.queryParams.add(parameter.getName());
                break;
            }
            case "path": {
                this.pathParams.add(parameter.getName());
                break;
            }
            case "header": {
                this.headerParams.add(parameter.getName());
                break;
            }
        }
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getPathParams() {
        return this.pathParams;
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public Set<String> getHeaderParams() {
        return this.headerParams;
    }

    public Collection<SecurityScheme> getSchemes() {
        return this.schemes;
    }
}

