/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.rest;

import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationId;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.NodeFactoryUtils;
import org.kie.kogito.serverless.workflow.parser.handlers.openapi.OpenAPIDescriptor;
import org.kie.kogito.serverless.workflow.parser.handlers.openapi.OpenAPIDescriptorFactory;
import org.kie.kogito.serverless.workflow.parser.rest.RestOperationHandler;
import org.kie.kogito.serverless.workflow.suppliers.ApiKeyAuthDecoratorSupplier;
import org.kie.kogito.serverless.workflow.suppliers.BasicAuthDecoratorSupplier;
import org.kie.kogito.serverless.workflow.suppliers.BearerTokenAuthDecoratorSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ClientOAuth2AuthDecoratorSupplier;
import org.kie.kogito.serverless.workflow.suppliers.CollectionParamsDecoratorSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ConfigSuppliedWorkItemSupplier;
import org.kie.kogito.serverless.workflow.suppliers.PasswordOAuth2AuthDecoratorSupplier;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;
import org.kogito.workitem.rest.auth.ApiKeyAuthDecorator;
import org.kogito.workitem.rest.auth.BearerTokenAuthDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorRestOperationHandler
implements RestOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(DescriptorRestOperationHandler.class);
    private final ParserContext parserContext;
    private final WorkflowOperationId operationId;

    public DescriptorRestOperationHandler(ParserContext parserContext, WorkflowOperationId operationId) {
        this.parserContext = parserContext;
        this.operationId = operationId;
    }

    @Override
    public <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> fillWorkItemHandler(WorkItemNodeFactory<T> node, Workflow workflow, FunctionDefinition actionFunction) {
        return NodeFactoryUtils.fillRest(this.addOpenApiParameters(node, workflow, actionFunction));
    }

    private <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> addOpenApiParameters(WorkItemNodeFactory<T> node, Workflow workflow, FunctionDefinition function) {
        URI uri = this.operationId.getUri();
        String serviceName = ServerlessWorkflowUtils.replaceNonAlphanumeric(this.operationId.getFileName());
        OpenAPI openAPI = DescriptorRestOperationHandler.getOpenAPI(uri, workflow, function, this.parserContext.getContext().getClassLoader());
        OpenAPIDescriptor openAPIDescriptor = OpenAPIDescriptorFactory.of(openAPI, this.operationId.getOperation());
        this.addSecurity(node, openAPIDescriptor, serviceName);
        return (WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)node.workParameter("Url", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "base_path", String.class, OpenAPIDescriptorFactory.getDefaultURL(openAPI, "http://localhost:8080"), (key, clazz, defaultValue) -> new ConfigSuppliedWorkItemSupplier<String>(key, clazz, (String)defaultValue, calculatedKey -> ConversionUtils.concatPaths((String)calculatedKey, (String)openAPIDescriptor.getPath()), (Expression)new LambdaExpr(new Parameter((Type)new UnknownType(), "calculatedKey"), (Expression)((MethodCallExpr)new MethodCallExpr(ConversionUtils.class.getCanonicalName() + ".concatPaths", new Expression[0]).addArgument((Expression)new NameExpr("calculatedKey"))).addArgument((Expression)new StringLiteralExpr(openAPIDescriptor.getPath()))))))).workParameter("Method", (Object)openAPIDescriptor.getMethod())).workParameter("ParamsDecorator", (Object)new CollectionParamsDecoratorSupplier(openAPIDescriptor.getHeaderParams(), openAPIDescriptor.getQueryParams()));
    }

    public static OpenAPI getOpenAPI(URI uri, Workflow workflow, FunctionDefinition function, ClassLoader cl) {
        SwaggerParseResult result = new OpenAPIParser().readContents(new String(URIContentLoaderFactory.readAllBytes((URIContentLoader)URIContentLoaderFactory.buildLoader((URI)uri, (ClassLoader)cl, (Workflow)workflow, (String)function.getAuthRef()))), null, null);
        OpenAPI openAPI = result.getOpenAPI();
        if (openAPI == null) {
            throw new IllegalArgumentException("Problem parsing uri " + uri + "Messages" + result.getMessages());
        }
        logger.debug("OpenAPI parser messages {}", (Object)result.getMessages());
        return openAPI;
    }

    private void addSecurity(WorkItemNodeFactory<?> node, OpenAPIDescriptor openAPI, String serviceName) {
        ArrayList<Supplier<Expression>> authDecorators = new ArrayList<Supplier<Expression>>();
        block5: for (SecurityScheme scheme : openAPI.getSchemes()) {
            switch (scheme.getType()) {
                case APIKEY: {
                    authDecorators.add(new ApiKeyAuthDecoratorSupplier(scheme.getName(), DescriptorRestOperationHandler.from(scheme.getIn())));
                    ((WorkItemNodeFactory)node.workParameter("apiKeyPrefix", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "api_key_prefix", this.parserContext.getContext()))).workParameter("apiKey", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "api_key", this.parserContext.getContext()));
                    continue block5;
                }
                case HTTP: {
                    if (scheme.getScheme().equals("bearer")) {
                        authDecorators.add(new BearerTokenAuthDecoratorSupplier());
                        ((WorkItemNodeFactory)node.workParameter("AuthMethod", (Object)new BearerTokenAuthDecorator())).workParameter("accessToken", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "access_token", this.parserContext.getContext()));
                        continue block5;
                    }
                    if (!scheme.getScheme().equals("basic")) continue block5;
                    authDecorators.add(new BasicAuthDecoratorSupplier());
                    ((WorkItemNodeFactory)node.workParameter("Username", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "username", this.parserContext.getContext()))).workParameter("Password", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "password", this.parserContext.getContext()));
                    continue block5;
                }
                case OAUTH2: {
                    if (scheme.getFlows().getClientCredentials() != null) {
                        authDecorators.add(new ClientOAuth2AuthDecoratorSupplier(scheme.getFlows().getClientCredentials().getTokenUrl(), scheme.getFlows().getClientCredentials().getRefreshUrl()));
                        ((WorkItemNodeFactory)node.workParameter("clientId", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "client_id", this.parserContext.getContext()))).workParameter("clientSecret", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "client_secret", this.parserContext.getContext()));
                        continue block5;
                    }
                    if (scheme.getFlows().getPassword() != null) {
                        authDecorators.add(new PasswordOAuth2AuthDecoratorSupplier(scheme.getFlows().getPassword().getTokenUrl(), scheme.getFlows().getPassword().getRefreshUrl()));
                        ((WorkItemNodeFactory)node.workParameter("Username", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "username", this.parserContext.getContext()))).workParameter("Password", ServerlessWorkflowUtils.runtimeOpenApi(serviceName, "password", this.parserContext.getContext()));
                        continue block5;
                    }
                    if (scheme.getFlows().getAuthorizationCode() != null) {
                        logger.warn("Unsupported scheme type {} for authorization code flow {}", (Object)scheme.getType(), (Object)scheme.getFlows().getAuthorizationCode());
                        continue block5;
                    }
                    if (scheme.getFlows().getImplicit() == null) continue block5;
                    logger.warn("Unsupported scheme type {} for implicit flow {}", (Object)scheme.getType(), (Object)scheme.getFlows().getImplicit());
                    continue block5;
                }
            }
            logger.warn("Unsupported scheme type {}", (Object)scheme.getType());
        }
        if (!authDecorators.isEmpty()) {
            node.workParameter("AuthMethod", authDecorators);
        }
    }

    private static ApiKeyAuthDecorator.Location from(SecurityScheme.In in) {
        switch (in) {
            case COOKIE: {
                return ApiKeyAuthDecorator.Location.COOKIE;
            }
            case HEADER: {
                return ApiKeyAuthDecorator.Location.HEADER;
            }
        }
        return ApiKeyAuthDecorator.Location.QUERY;
    }
}

