/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.types;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandlerFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.types.WorkItemTypeHandler;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class ServiceTypeHandler
extends WorkItemTypeHandler {
    private static final String SERVICE_TASK_TYPE = "Service Task";
    private static final String SERVICE_IMPL_KEY = "implementation";
    private static final String WORKITEM_PARAM_TYPE = "ParameterType";
    private static final String WORKITEM_PARAM = "Parameter";
    private static final String WORKITEM_INTERFACE = "Interface";
    private static final String WORKITEM_OPERATION = "Operation";
    private static final String WORKITEM_INTERFACE_IMPL = "interfaceImplementationRef";
    private static final String WORKITEM_OPERATION_IMPL = "operationImplementationRef";
    private static final String INTFC_SEPARATOR = "::";
    private static final String LANG_SEPARATOR = ":";

    @Override
    protected WorkItemNodeFactory<?> buildWorkItem(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, ParserContext context, String inputVar, String outputVar) {
        return (WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)embeddedSubProcess.workItemNode(context.newId()).metaData("Type", (Object)SERVICE_TASK_TYPE)).workName(SERVICE_TASK_TYPE)).inMapping(inputVar, WORKITEM_PARAM)).outMapping(WORKITEM_PARAM, outputVar);
    }

    @Override
    protected <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> addFunctionArgs(Workflow workflow, WorkItemNodeFactory<T> node, FunctionRef functionRef) {
        JsonNode functionArgs = functionRef.getArguments();
        if (functionArgs == null || functionArgs.isEmpty()) {
            node.workParameter(WORKITEM_PARAM_TYPE, (Object)"com.fasterxml.jackson.databind.JsonNode");
        } else {
            this.processArgs(workflow, node, functionArgs, WORKITEM_PARAM);
        }
        return node;
    }

    @Override
    protected <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> fillWorkItemHandler(Workflow workflow, ParserContext context, WorkItemNodeFactory<T> node, FunctionDefinition functionDef) {
        String intfc = null;
        String method = null;
        String lang = null;
        String operation = FunctionTypeHandlerFactory.trimCustomOperation(functionDef);
        int indexOf = operation.indexOf(INTFC_SEPARATOR);
        if (indexOf != -1) {
            method = operation.substring(indexOf + INTFC_SEPARATOR.length());
            if ((indexOf = (operation = operation.substring(0, indexOf)).indexOf(LANG_SEPARATOR)) != -1) {
                intfc = operation.substring(indexOf + LANG_SEPARATOR.length());
                lang = operation.substring(0, indexOf);
            } else {
                intfc = operation;
            }
        }
        if (lang == null) {
            lang = ServerlessWorkflowUtils.resolveFunctionMetadata(functionDef, SERVICE_IMPL_KEY, context.getContext(), String.class, "Java");
        }
        return (WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)node.workParameter(WORKITEM_INTERFACE, intfc)).workParameter(WORKITEM_OPERATION, (Object)method)).workParameter(WORKITEM_INTERFACE_IMPL, intfc)).workParameter(WORKITEM_OPERATION_IMPL, (Object)method)).workParameter(SERVICE_IMPL_KEY, (Object)lang);
    }

    @Override
    public String type() {
        return "service";
    }
}

