/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandler;

public class FunctionTypeHandlerFactory {
    private static final FunctionTypeHandlerFactory INSTANCE = new FunctionTypeHandlerFactory();
    private static final String CUSTOM_TYPE_SEPARATOR = ":";
    private final Map<String, FunctionTypeHandler> typeMap = new HashMap<String, FunctionTypeHandler>();
    private final Map<String, FunctionTypeHandler> customMap = new HashMap<String, FunctionTypeHandler>();

    public static FunctionTypeHandlerFactory instance() {
        return INSTANCE;
    }

    public Optional<FunctionTypeHandler> getTypeHandler(FunctionDefinition functionDef) {
        String key;
        Map<String, FunctionTypeHandler> map;
        boolean isCustom;
        boolean bl = isCustom = functionDef.getType() == FunctionDefinition.Type.CUSTOM;
        if (isCustom) {
            map = this.customMap;
            key = FunctionTypeHandlerFactory.getTypeFromOperation(functionDef);
        } else {
            map = this.typeMap;
            key = functionDef.getType().toString();
        }
        return Optional.ofNullable(map.get(key));
    }

    private static String getTypeFromOperation(FunctionDefinition functionDef) {
        return FunctionTypeHandlerFactory.trimString(functionDef, FunctionTypeHandlerFactory::trimStart);
    }

    private static String trimStart(String operation, int indexOf) {
        return operation.substring(0, indexOf);
    }

    private static String trimEnd(String operation, int indexOf) {
        return operation.substring(indexOf + 1);
    }

    private static String trimString(FunctionDefinition functionDef, BiFunction<String, Integer, String> function) {
        String operation = functionDef.getOperation();
        int indexOf = operation.indexOf(CUSTOM_TYPE_SEPARATOR);
        return indexOf == -1 ? operation : function.apply(operation, indexOf);
    }

    public static String trimCustomOperation(FunctionDefinition functionDef) {
        return FunctionTypeHandlerFactory.trimString(functionDef, FunctionTypeHandlerFactory::trimEnd);
    }

    private FunctionTypeHandlerFactory() {
        ServiceLoader.load(FunctionTypeHandler.class).forEach(handler -> (handler.isCustom() ? this.customMap : this.typeMap).put(handler.type(), (FunctionTypeHandler)handler));
    }
}

