/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.events.EventRef;
import io.serverlessworkflow.api.filters.ActionDataFilter;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.functions.SubFlowRef;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.sleep.Sleep;
import io.serverlessworkflow.api.workflow.Functions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.AbstractCompositeNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.TimerNodeFactory;
import org.kie.kogito.serverless.workflow.parser.FunctionNamespaceFactory;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandlerFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.VariableInfo;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.parser.handlers.NodeFactoryUtils;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;

public abstract class CompositeContextNodeHandler<S extends State>
extends StateHandler<S> {
    protected CompositeContextNodeHandler(S state, Workflow workflow, ParserContext parserContext) {
        super(state, workflow, parserContext);
    }

    protected final CompositeContextNodeFactory<?> makeCompositeNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        return (CompositeContextNodeFactory)((CompositeContextNodeFactory)factory.compositeContextNode(this.parserContext.newId()).name(this.state.getName())).autoComplete(true);
    }

    protected final <T extends AbstractCompositeNodeFactory<?, ?>> T handleActions(T embeddedSubProcess, List<Action> actions) {
        return this.handleActions(embeddedSubProcess, actions, this.getVarName(), true);
    }

    protected final <T extends AbstractCompositeNodeFactory<?, ?>> T handleActions(T embeddedSubProcess, List<Action> actions, String outputVar, boolean shouldMerge) {
        if (actions != null && !actions.isEmpty()) {
            NodeFactory<?, ?> startNode;
            NodeFactory<?, ?> currentNode = startNode = embeddedSubProcess.startNode(this.parserContext.newId()).name("EmbeddedStart");
            for (Action action : actions) {
                Sleep sleep = action.getSleep();
                if (sleep != null && CompositeContextNodeHandler.isDurationThere(sleep.getBefore())) {
                    currentNode = this.connect(currentNode, (NodeFactory<?, ?>)this.createTimerNode((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, sleep.getBefore()));
                }
                currentNode = this.connect(currentNode, this.getActionNode((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, action, outputVar, shouldMerge));
                if (sleep == null || !CompositeContextNodeHandler.isDurationThere(sleep.getAfter())) continue;
                currentNode = this.connect(currentNode, (NodeFactory<?, ?>)this.createTimerNode((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, sleep.getAfter()));
            }
            this.connect(currentNode, (NodeFactory<?, ?>)((EndNodeFactory)embeddedSubProcess.endNode(this.parserContext.newId()).name("EmbeddedEnd")).terminate(true)).done();
        } else {
            this.connect((NodeFactory<?, ?>)embeddedSubProcess.startNode(this.parserContext.newId()).name("EmbeddedStart"), (NodeFactory<?, ?>)((EndNodeFactory)embeddedSubProcess.endNode(this.parserContext.newId()).name("EmbeddedEnd")).terminate(true)).done();
        }
        this.handleErrors((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory(), (RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess);
        return embeddedSubProcess;
    }

    protected final MakeNodeResult getActionNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, Action action) {
        return this.getActionNode(embeddedSubProcess, action, this.getVarName(), true);
    }

    protected final MakeNodeResult getActionNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, Action action, String collectVar, boolean shouldMerge) {
        ActionDataFilter actionFilter = action.getActionDataFilter();
        String fromExpr = null;
        String resultExpr = null;
        String toExpr = null;
        boolean useData = true;
        if (actionFilter != null) {
            fromExpr = actionFilter.getFromStateData();
            resultExpr = actionFilter.getResults();
            toExpr = actionFilter.getToStateData();
            useData = actionFilter.isUseResults();
        }
        if (action.getFunctionRef() != null) {
            return this.filterAndMergeNode(embeddedSubProcess, collectVar, fromExpr, resultExpr, toExpr, useData, shouldMerge, (factory, inputVar, outputVar) -> this.getActionNode(factory, action.getFunctionRef(), inputVar, outputVar));
        }
        if (action.getEventRef() != null) {
            return this.filterAndMergeNode(embeddedSubProcess, collectVar, fromExpr, resultExpr, toExpr, useData, shouldMerge, (factory, inputVar, outputVar) -> this.getActionNode(factory, action.getEventRef(), inputVar));
        }
        if (action.getSubFlowRef() != null) {
            return this.filterAndMergeNode(embeddedSubProcess, collectVar, fromExpr, resultExpr, toExpr, useData, shouldMerge, (factory, inputVar, outputVar) -> this.getActionNode(factory, action.getSubFlowRef(), inputVar, outputVar));
        }
        throw new IllegalArgumentException("Action node " + action.getName() + " of state " + this.state.getName() + " does not have function or event defined");
    }

    private TimerNodeFactory<?> createTimerNode(RuleFlowNodeContainerFactory<?, ?> factory, String duration) {
        return NodeFactoryUtils.timerNode(factory.timerNode(this.parserContext.newId()), duration);
    }

    private NodeFactory<?, ?> getActionNode(RuleFlowNodeContainerFactory<?, ?> factory, SubFlowRef subFlowRef, String inputVar, String outputVar) {
        return NodeFactoryUtils.subprocessNode(((SubProcessNodeFactory)factory.subProcessNode(this.parserContext.newId()).name(subFlowRef.getWorkflowId())).processId(subFlowRef.getWorkflowId()).waitForCompletion(true), inputVar, outputVar);
    }

    private NodeFactory<?, ?> getActionNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, EventRef eventRef, String inputVar) {
        return this.sendEventNode(embeddedSubProcess.actionNode(this.parserContext.newId()), this.eventDefinition(eventRef.getTriggerEventRef()), eventRef.getData(), inputVar);
    }

    private NodeFactory<?, ?> getActionNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, FunctionRef functionRef, String inputVar, String outputVar) {
        String functionName = functionRef.getRefName();
        VariableInfo varInfo = new VariableInfo(inputVar, outputVar);
        return this.getFunctionDefStream().filter(wf -> wf.getName().equals(functionName)).findFirst().map(functionDef -> this.fromFunctionDefinition(embeddedSubProcess, (FunctionDefinition)functionDef, functionRef, varInfo)).or(() -> this.fromPredefinedFunction(embeddedSubProcess, functionRef, varInfo)).orElseThrow(() -> new IllegalArgumentException("Cannot find function " + functionName));
    }

    private Stream<FunctionDefinition> getFunctionDefStream() {
        Functions functions = this.workflow.getFunctions();
        return functions == null ? Stream.empty() : this.workflow.getFunctions().getFunctionDefs().stream();
    }

    private NodeFactory fromFunctionDefinition(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, FunctionDefinition functionDef, FunctionRef functionRef, VariableInfo varInfo) {
        return FunctionTypeHandlerFactory.instance().getTypeHandler(functionDef).map(type -> type.getActionNode(this.workflow, this.parserContext, embeddedSubProcess, functionDef, functionRef, varInfo)).orElseGet(() -> embeddedSubProcess.actionNode(this.parserContext.newId()).name(functionRef.getRefName()).action("java", ""));
    }

    private Optional<NodeFactory> fromPredefinedFunction(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, FunctionRef functionRef, VariableInfo varInfo) {
        return FunctionNamespaceFactory.instance().getNamespace(functionRef).map(f -> f.getActionNode(this.workflow, this.parserContext, embeddedSubProcess, functionRef, varInfo));
    }

    private static boolean isDurationThere(String sleepTime) {
        return sleepTime != null && !sleepTime.isBlank();
    }
}

