/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.error.ErrorDefinition;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.filters.EventDataFilter;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.transitions.Transition;
import io.serverlessworkflow.api.workflow.Errors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.BoundaryEventNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.SupportsAction;
import org.jbpm.ruleflow.core.factory.TimerNodeFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.parser.handlers.NodeFactoryUtils;
import org.kie.kogito.serverless.workflow.suppliers.CollectorActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.CompensationActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ExpressionActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.MergeActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ProduceEventActionSupplier;
import org.kie.kogito.serverless.workflow.utils.TimeoutsConfigResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateHandler<S extends State> {
    private static Logger logger = LoggerFactory.getLogger(StateHandler.class);
    protected final S state;
    protected final Workflow workflow;
    protected final ParserContext parserContext;
    private NodeFactory<?, ?> startNodeFactory;
    private EndNodeFactory<?> endNodeFactory;
    private NodeFactory<?, ?> node;
    private NodeFactory<?, ?> outgoingNode;
    protected final boolean isStartState;
    private JoinFactory<?> join;
    private Collection<Long> incomingConnections = new LinkedHashSet<Long>();

    protected StateHandler(S state, Workflow workflow, ParserContext parserContext) {
        this.workflow = workflow;
        this.state = state;
        this.parserContext = parserContext;
        this.isStartState = state.getName().equals(workflow.getStart().getStateName());
    }

    public boolean usedForCompensation() {
        return false;
    }

    public void handleStart() {
        if (this.isStartState) {
            this.startNodeFactory = this.parserContext.factory().startNode(this.parserContext.newId()).name("Start");
            this.startNodeFactory.done();
        }
    }

    public void handleEnd() {
        End endState = this.state.getEnd();
        if (endState != null) {
            this.endNodeFactory = (EndNodeFactory)this.endNodeFactory((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory(), endState).name("End");
            this.endNodeFactory.done();
        }
    }

    protected final <T extends NodeFactory<?, ?>> NodeFactory<?, ?> sendEventNode(T actionNode, ProduceEvent event) {
        return this.sendEventNode(actionNode, this.eventDefinition(event.getEventRef()), event.getData(), "workflowdata");
    }

    protected final <T extends NodeFactory<?, ?>> NodeFactory<?, ?> sendEventNode(T actionNode, EventDefinition eventDefinition, String data, String defaultWorkflowVar) {
        return NodeFactoryUtils.sendEventNode(((SupportsAction)actionNode).action((Action)new ProduceEventActionSupplier(this.workflow, data)), eventDefinition, defaultWorkflowVar);
    }

    private void handleCompensation(RuleFlowNodeContainerFactory<?, ?> factory) {
        StateHandler<?> compensation = this.parserContext.getStateHandler(this.state.getCompensatedBy());
        if (compensation == null) {
            throw new IllegalArgumentException("State " + this.getState().getName() + " refers to a compensation " + this.state.getCompensatedBy() + " which cannot be found");
        }
        this.parserContext.setCompensation();
        long eventCompensationId = this.parserContext.newId();
        long subprocessCompensationId = this.parserContext.newId();
        long startCompensationId = this.parserContext.newId();
        String uniqueId = (String)this.outgoingNode.getNode().getMetaData().get("UniqueId");
        factory.boundaryEventNode(eventCompensationId).addCompensationHandler(uniqueId).attachedTo(uniqueId).eventType("Compensation").metaData("EventType", (Object)"compensation");
        CompositeContextNodeFactory embeddedSubProcess = (CompositeContextNodeFactory)((CompositeContextNodeFactory)((CompositeContextNodeFactory)factory.compositeContextNode(subprocessCompensationId).autoComplete(true)).metaData("isForCompensation", (Object)true)).startNode(startCompensationId).interrupting(true).done();
        factory.association(eventCompensationId, subprocessCompensationId, null);
        long lastNodeId = this.handleCompensation((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, compensation);
        embeddedSubProcess.connection(startCompensationId, lastNodeId);
        compensation = this.parserContext.getStateHandler(compensation);
        while (compensation != null) {
            if (!compensation.usedForCompensation()) {
                throw new IllegalArgumentException("compensation node can only have transition to other compensation node. Node " + compensation.getState().getName() + " is not used for compensation");
            }
            lastNodeId = this.handleCompensation((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, compensation);
            compensation = this.parserContext.getStateHandler(compensation);
        }
        long endCompensationId = this.parserContext.newId();
        ((CompositeContextNodeFactory)embeddedSubProcess.endNode(endCompensationId).terminate(false).done()).connection(lastNodeId, endCompensationId);
    }

    private long handleCompensation(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, StateHandler<?> compensation) {
        if (compensation.getState().getCompensatedBy() != null) {
            throw new IllegalArgumentException("Serverless workflow specification forbids nested compensations, hence state " + compensation.getState().getName() + " is not valid");
        }
        compensation.handleState(embeddedSubProcess);
        Transition transition = compensation.getState().getTransition();
        long lastNodeId = compensation.getNode().getNode().getId();
        compensation.handleTransitions(embeddedSubProcess, transition, lastNodeId);
        compensation.handleConnections(embeddedSubProcess);
        return lastNodeId;
    }

    public void handleState() {
        this.handleState((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory());
    }

    protected void handleState(RuleFlowNodeContainerFactory<?, ?> factory) {
        MakeNodeResult result = this.makeNode(factory);
        this.node = result.getIncomingNode();
        this.outgoingNode = result.getOutgoingNode();
        if (this.state.getCompensatedBy() != null) {
            this.handleCompensation(factory);
        }
        this.node.done();
        this.outgoingNode.done();
        StateDataFilter stateFilter = this.state.getStateDataFilter();
        if (stateFilter != null) {
            String output;
            String input = stateFilter.getInput();
            if (input != null) {
                ActionNodeFactory<?> actionNode = this.handleStateFilter(factory, input);
                factory.connection(actionNode.getNode().getId(), this.node.getNode().getId());
                this.node = actionNode;
            }
            if ((output = stateFilter.getOutput()) != null) {
                ActionNodeFactory<?> actionNode = this.handleStateFilter(factory, output);
                factory.connection(this.outgoingNode.getNode().getId(), actionNode.getNode().getId());
                this.outgoingNode = actionNode;
            }
        }
        this.connectStart(factory);
        this.connectEnd(factory);
    }

    private ActionNodeFactory<?> handleStateFilter(RuleFlowNodeContainerFactory<?, ?> factory, String filter) {
        ActionNodeFactory result = factory.actionNode(this.parserContext.newId()).action((Action)ExpressionActionSupplier.of(this.workflow, filter).build());
        result.done();
        return result;
    }

    public void connect(RuleFlowNodeContainerFactory<?, ?> factory, long sourceId) {
        this.incomingConnections.add(sourceId);
    }

    public void handleConnections() {
        this.handleConnections((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory());
    }

    protected void handleConnections(RuleFlowNodeContainerFactory<?, ?> factory) {
        NodeFactory<?, ?> incoming = this.getIncomingNode(factory);
        for (long sourceId : this.incomingConnections) {
            factory.connection(sourceId, incoming.getNode().getId());
        }
    }

    private boolean hasCode(ErrorDefinition errorDef) {
        if (errorDef.getCode() == null) {
            logger.error("Kogito requires code error to be set. Ignoring {}", (Object)errorDef.getName());
            return false;
        }
        return true;
    }

    protected final Collection<ErrorDefinition> getErrorDefinitions(Error error) {
        Errors errors = this.workflow.getErrors();
        if (errors == null) {
            throw new IllegalArgumentException("workflow should contain errors property");
        }
        List errorDefs = errors.getErrorDefs();
        if (errorDefs == null) {
            throw new IllegalArgumentException("workflow errors property must contain errorDefs property");
        }
        if (error.getErrorRef() != null) {
            return this.getErrorsDefinitions(errorDefs, Arrays.asList(error.getErrorRef()));
        }
        if (error.getErrorRefs() != null) {
            return this.getErrorsDefinitions(errorDefs, error.getErrorRefs());
        }
        throw new IllegalArgumentException("state errors should contain either errorRef or errorRefs property");
    }

    private Collection<ErrorDefinition> getErrorsDefinitions(List<ErrorDefinition> errorDefs, List<String> errorRefs) {
        ArrayList<ErrorDefinition> result = new ArrayList<ErrorDefinition>();
        for (String errorRef : errorRefs) {
            result.add(errorDefs.stream().filter(errorDef -> errorDef.getName().equals(errorRef) && this.hasCode((ErrorDefinition)errorDef)).findAny().orElseThrow(() -> new IllegalArgumentException("Cannot find any error definition for errorRef" + errorRef)));
        }
        return result;
    }

    protected final void handleErrors(RuleFlowNodeContainerFactory<?, ?> factory, RuleFlowNodeContainerFactory<?, ?> targetNode) {
        for (Error error : this.state.getOnErrors()) {
            this.getErrorDefinitions(error).forEach(errorDef -> {
                String errorPrefix = "Error-" + targetNode.getNode().getMetaData().get("UniqueId") + "-";
                BoundaryEventNodeFactory boundaryNode = (BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)factory.boundaryEventNode(this.parserContext.newId()).attachedTo(targetNode.getNode().getId()).metaData("EventType", (Object)"error")).metaData("HasErrorEvent", (Object)true)).metaData("ErrorEvent", (Object)errorDef.getCode())).eventType(errorPrefix + errorDef.getCode()).name("Error-" + targetNode.getNode().getName() + "-" + errorDef.getCode());
                targetNode.exceptionHandler(errorDef.getCode(), errorDef.getCode());
                if (error.getEnd() != null) {
                    this.connect((NodeFactory<?, ?>)boundaryNode, (NodeFactory<?, ?>)this.endNodeFactory(factory, error.getEnd()));
                } else {
                    this.handleTransitions(factory, error.getTransition(), boundaryNode.getNode().getId());
                }
            });
        }
    }

    public void handleTransitions() {
        this.handleTransitions((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory(), this.state.getTransition(), this.outgoingNode.getNode().getId());
    }

    protected void handleTransitions(RuleFlowNodeContainerFactory<?, ?> factory, Transition transition, long sourceId) {
        this.handleTransition(factory, transition, sourceId, Optional.empty());
    }

    private void connectStart(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.startNodeFactory != null) {
            factory.connection(this.startNodeFactory.getNode().getId(), this.node.getNode().getId());
        }
    }

    private void connectEnd(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.endNodeFactory != null) {
            if (this.state.getEnd().isCompensate()) {
                this.endNodeFactory.done().connection(this.compensationEvent(factory, this.outgoingNode.getNode().getId()), this.endNodeFactory.getNode().getId());
            } else {
                factory.connection(this.outgoingNode.getNode().getId(), this.endNodeFactory.getNode().getId());
            }
        }
    }

    public final NodeFactory<?, ?> getNode() {
        return this.node;
    }

    public S getState() {
        return this.state;
    }

    public NodeFactory<?, ?> getIncomingNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.join != null) {
            return this.join;
        }
        if (this.incomingConnections.size() > 1) {
            this.join = factory.joinNode(this.parserContext.newId()).type(5).name("Join-" + this.node.getNode().getName());
            this.join.done().connection(this.join.getNode().getId(), this.node.getNode().getId());
            return this.join;
        }
        return this.getNode();
    }

    protected abstract MakeNodeResult makeNode(RuleFlowNodeContainerFactory<?, ?> var1);

    protected final void handleTransition(RuleFlowNodeContainerFactory<?, ?> factory, Transition transition, long sourceId, Optional<HandleTransitionCallBack> callback) {
        StateHandler<?> targetState = this.parserContext.getStateHandler(transition);
        if (targetState != null) {
            List produceEvents = transition.getProduceEvents();
            if (produceEvents.isEmpty()) {
                if (transition.isCompensate()) {
                    long eventId = this.compensationEvent(factory, sourceId);
                    targetState.connect(factory, eventId);
                    callback.ifPresent(c -> c.onIdTarget(eventId));
                } else {
                    targetState.connect(factory, sourceId);
                    callback.ifPresent(c -> c.onStateTarget(targetState));
                }
            } else {
                ActionNodeFactory actionNode = factory.actionNode(this.parserContext.newId());
                NodeFactory<?, ?> endNode = this.handleProduceEvents(factory, actionNode, produceEvents);
                factory.connection(sourceId, actionNode.getNode().getId());
                if (transition.isCompensate()) {
                    long eventId = this.compensationEvent(factory, sourceId);
                    callback.ifPresent(c -> c.onIdTarget(eventId));
                } else {
                    callback.ifPresent(c -> c.onIdTarget(actionNode.getNode().getId()));
                }
                targetState.connect(factory, endNode.getNode().getId());
            }
        } else {
            callback.ifPresent(HandleTransitionCallBack::onEmptyTarget);
        }
    }

    private <T extends NodeFactory<?, ?>> NodeFactory<?, ?> handleProduceEvents(RuleFlowNodeContainerFactory<?, ?> factory, T startNode, List<ProduceEvent> produceEvents) {
        Object endNode = startNode;
        this.sendEventNode(startNode, produceEvents.get(0));
        if (produceEvents.size() > 1) {
            ListIterator<ProduceEvent> iter = produceEvents.listIterator(1);
            while (iter.hasNext()) {
                endNode = this.connect((NodeFactory<?, ?>)endNode, this.sendEventNode(factory.actionNode(this.parserContext.newId()), iter.next()));
            }
        }
        return endNode;
    }

    protected final String getVarName() {
        return this.state.getName() + "_" + this.parserContext.newId();
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, EventDataFilter eventFilter, FilterableNodeSupplier nodeSupplier) {
        return this.filterAndMergeNode(embeddedSubProcess, eventFilter, this.getVarName(), nodeSupplier);
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, EventDataFilter eventFilter, String varName, FilterableNodeSupplier nodeSupplier) {
        String dataExpr = null;
        String toExpr = null;
        boolean useData = true;
        if (eventFilter != null) {
            dataExpr = eventFilter.getData();
            toExpr = eventFilter.getToStateData();
            useData = eventFilter.isUseData();
        }
        return this.filterAndMergeNode(embeddedSubProcess, varName, null, dataExpr, toExpr, useData, true, nodeSupplier);
    }

    protected boolean isTempVariable(String varName) {
        return !varName.equals("workflowdata");
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, String actionVarName, String fromStateExpr, String resultExpr, String toStateExpr, boolean useData, boolean shouldMerge, FilterableNodeSupplier nodeSupplier) {
        NodeFactory<?, ?> currentNode;
        NodeFactory<?, ?> startNode;
        if (this.isTempVariable(actionVarName)) {
            embeddedSubProcess.variable(actionVarName, (DataType)new ObjectDataType(JsonNode.class.getCanonicalName()), "customTags", (Object)"internal");
        }
        if (fromStateExpr != null) {
            startNode = embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)ExpressionActionSupplier.of(this.workflow, fromStateExpr).withVarNames("workflowdata", actionVarName).build());
            currentNode = this.connect(startNode, nodeSupplier.apply(embeddedSubProcess, actionVarName, actionVarName));
        } else {
            startNode = currentNode = nodeSupplier.apply(embeddedSubProcess, "workflowdata", actionVarName);
        }
        if (useData && resultExpr != null) {
            currentNode = this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)ExpressionActionSupplier.of(this.workflow, resultExpr).withVarNames(actionVarName, actionVarName).build()));
        }
        if (useData) {
            if (toStateExpr != null) {
                currentNode = this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)new CollectorActionSupplier(this.workflow.getExpressionLang(), toStateExpr, "workflowdata", actionVarName)));
            } else if (shouldMerge) {
                currentNode = this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)new MergeActionSupplier(actionVarName, "workflowdata")));
            }
        }
        currentNode.done();
        return new MakeNodeResult(startNode, currentNode);
    }

    protected final NodeFactory<?, ?> connect(NodeFactory<?, ?> currentNode, NodeFactory<?, ?> nodeFactory) {
        currentNode.done().connection(currentNode.getNode().getId(), nodeFactory.getNode().getId());
        return nodeFactory;
    }

    protected final NodeFactory<?, ?> connect(NodeFactory<?, ?> currentNode, MakeNodeResult twoNodes) {
        this.connect(currentNode, twoNodes.getIncomingNode()).done();
        return twoNodes.getOutgoingNode();
    }

    protected final NodeFactory<?, ?> consumeEventNode(RuleFlowNodeContainerFactory<?, ?> factory, String eventRef, String inputVar, String outputVar) {
        EventDefinition eventDefinition = this.eventDefinition(eventRef);
        return NodeFactoryUtils.consumeMessageNode(factory.eventNode(this.parserContext.newId()), eventDefinition, inputVar, outputVar);
    }

    protected final EventDefinition eventDefinition(String eventName) {
        return this.workflow.getEvents().getEventDefs().stream().filter(wt -> wt.getName().equals(eventName)).findFirst().orElseThrow(() -> new NoSuchElementException("No event for " + eventName));
    }

    protected final MakeNodeResult makeTimeoutNode(RuleFlowNodeContainerFactory<?, ?> factory, MakeNodeResult notTimerBranch, int type) {
        String eventTimeout = TimeoutsConfigResolver.resolveEventTimeout(this.state, this.workflow);
        if (eventTimeout != null) {
            if (StateHandler.isPreparedBranch(notTimerBranch, type)) {
                this.createTimerNode(factory, (SplitFactory)notTimerBranch.getIncomingNode(), (JoinFactory)notTimerBranch.getOutgoingNode(), eventTimeout);
                return notTimerBranch;
            }
            SplitFactory splitNode = NodeFactoryUtils.eventBasedSplitNode(factory.splitNode(this.parserContext.newId()), type);
            JoinFactory joinNode = NodeFactoryUtils.joinExclusiveNode(factory.joinNode(this.parserContext.newId()));
            this.connect(this.connect((NodeFactory<?, ?>)splitNode, notTimerBranch), (NodeFactory<?, ?>)joinNode);
            this.createTimerNode(factory, splitNode, joinNode, eventTimeout);
            return new MakeNodeResult((NodeFactory<?, ?>)splitNode, (NodeFactory<?, ?>)joinNode);
        }
        return notTimerBranch;
    }

    private void createTimerNode(RuleFlowNodeContainerFactory<?, ?> factory, SplitFactory<?> splitNode, JoinFactory<?> joinNode, String eventTimeout) {
        TimerNodeFactory eventTimeoutTimerNode = NodeFactoryUtils.timerNode(factory.timerNode(this.parserContext.newId()), eventTimeout);
        this.connect((NodeFactory<?, ?>)splitNode, (NodeFactory<?, ?>)eventTimeoutTimerNode);
        this.connect((NodeFactory<?, ?>)eventTimeoutTimerNode, (NodeFactory<?, ?>)joinNode);
    }

    private static final boolean isPreparedBranch(MakeNodeResult notTimerBranch, int splitType) {
        NodeFactory<?, ?> incoming = notTimerBranch.getIncomingNode();
        NodeFactory<?, ?> outgoing = notTimerBranch.getOutgoingNode();
        return incoming instanceof SplitFactory && outgoing instanceof JoinFactory && ((SplitFactory)incoming).getSplit().getType() == splitType && ((JoinFactory)outgoing).getJoin().getType() == 2;
    }

    protected EndNodeFactory<?> endNodeFactory(RuleFlowNodeContainerFactory<?, ?> factory, End end) {
        EndNodeFactory nodeFactory = factory.endNode(this.parserContext.newId());
        List produceEvents = end.getProduceEvents();
        if (produceEvents != null && !produceEvents.isEmpty()) {
            this.sendEventNode(nodeFactory, (ProduceEvent)produceEvents.get(0));
        }
        nodeFactory.terminate(end.isTerminate());
        return nodeFactory;
    }

    private long compensationEvent(RuleFlowNodeContainerFactory<?, ?> factory, long sourceId) {
        long eventId = this.parserContext.newId();
        factory.actionNode(eventId).name(this.state.getName() + "-" + eventId).action((Action)new CompensationActionSupplier("implicit:" + this.workflow.getId())).done().connection(sourceId, eventId);
        return eventId;
    }

    protected static interface HandleTransitionCallBack {
        default public void onStateTarget(StateHandler<?> targetState) {
        }

        default public void onIdTarget(long targetId) {
        }

        default public void onEmptyTarget() {
        }
    }

    @FunctionalInterface
    protected static interface FilterableNodeSupplier {
        public NodeFactory<?, ?> apply(RuleFlowNodeContainerFactory<?, ?> var1, String var2, String var3);
    }
}

