/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.kie.kogito.serverless.workflow.parser.handlers.openapi.OpenAPIDescriptor;

public class OpenAPIDescriptorFactory {
    public static OpenAPIDescriptor of(OpenAPI openAPI, String operationId) {
        Map<String, List<OperationInfo>> operations = OpenAPIDescriptorFactory.collectOperations(openAPI.getPaths(), operationId);
        if (operations.isEmpty()) {
            throw new IllegalArgumentException("Cannot find operation for " + operationId);
        }
        if (operations.size() > 1) {
            throw new IllegalArgumentException("There is more than one operation " + operations + " in different paths with name " + operationId);
        }
        Map.Entry<String, List<OperationInfo>> operEntry = operations.entrySet().iterator().next();
        if (operEntry.getValue().size() > 1) {
            throw new IllegalArgumentException("There is more than one operation " + operations + " in different methods with name " + operationId + " for path " + operEntry.getKey());
        }
        OperationInfo operation = operEntry.getValue().get(0);
        return new OpenAPIDescriptor(operation.getMethod(), operEntry.getKey(), operation.getOperation(), OpenAPIDescriptorFactory.getSchemes(openAPI, operation.getOperation()));
    }

    private static Collection<SecurityScheme> getSchemes(OpenAPI openAPI, Operation operation) {
        HashMap schemes;
        HashSet schemeNames = new HashSet();
        List security = operation.getSecurity();
        if (security != null) {
            if (security.isEmpty()) {
                return Collections.emptyList();
            }
            security.forEach(s -> schemeNames.addAll(s.keySet()));
        }
        if (openAPI.getComponents() != null && (schemes = openAPI.getComponents().getSecuritySchemes()) != null) {
            if (!schemeNames.isEmpty()) {
                schemes = new HashMap(schemes);
                schemes.keySet().retainAll(schemeNames);
            }
            return schemes.values();
        }
        return Collections.emptyList();
    }

    private static void checkOperation(String path, String operationId, HttpMethod method, Operation operation, Map<String, List<OperationInfo>> map) {
        if (operation != null && (operationId.equals(operation.getOperationId()) || operationId.equals(ConversionUtils.toCamelCase((String)operation.getOperationId())))) {
            map.computeIfAbsent(path, k -> new ArrayList()).add(new OperationInfo(method, operation));
        }
    }

    private static Map<String, List<OperationInfo>> collectOperations(Paths paths, String operationId) {
        HashMap<String, List<OperationInfo>> result = new HashMap<String, List<OperationInfo>>();
        for (Map.Entry path : paths.entrySet()) {
            OpenAPIDescriptorFactory.checkOperation((String)path.getKey(), operationId, HttpMethod.GET, ((PathItem)path.getValue()).getGet(), result);
            OpenAPIDescriptorFactory.checkOperation((String)path.getKey(), operationId, HttpMethod.HEAD, ((PathItem)path.getValue()).getHead(), result);
            OpenAPIDescriptorFactory.checkOperation((String)path.getKey(), operationId, HttpMethod.DELETE, ((PathItem)path.getValue()).getDelete(), result);
            OpenAPIDescriptorFactory.checkOperation((String)path.getKey(), operationId, HttpMethod.PATCH, ((PathItem)path.getValue()).getPatch(), result);
            OpenAPIDescriptorFactory.checkOperation((String)path.getKey(), operationId, HttpMethod.POST, ((PathItem)path.getValue()).getPost(), result);
            OpenAPIDescriptorFactory.checkOperation((String)path.getKey(), operationId, HttpMethod.PUT, ((PathItem)path.getValue()).getPut(), result);
            OpenAPIDescriptorFactory.checkOperation((String)path.getKey(), operationId, HttpMethod.OPTIONS, ((PathItem)path.getValue()).getOptions(), result);
            OpenAPIDescriptorFactory.checkOperation((String)path.getKey(), operationId, HttpMethod.TRACE, ((PathItem)path.getValue()).getTrace(), result);
        }
        return result;
    }

    public static String getDefaultURL(OpenAPI openAPI, String defaultBase) {
        List servers = openAPI.getServers();
        return servers != null && !servers.isEmpty() ? ((Server)servers.get(0)).getUrl() : defaultBase;
    }

    private OpenAPIDescriptorFactory() {
    }

    private static class OperationInfo {
        private final HttpMethod method;
        private final Operation operation;

        public OperationInfo(HttpMethod method, Operation operation) {
            this.method = method;
            this.operation = operation;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String toString() {
            return "OperationInfo [method=" + this.method + ", operation=" + this.operation + "]";
        }
    }
}

