/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.serverlessworkflow.api.Workflow;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.parser.schema.JsonSchemaImpl;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenApiModelSchemaGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiModelSchemaGenerator.class);

    private OpenApiModelSchemaGenerator() {
    }

    private static Optional<Schema> generateInputModel(Workflow workflow) {
        if (workflow.getDataInputSchema() == null || workflow.getDataInputSchema().getSchema() == null || workflow.getDataInputSchema().getSchema().isEmpty()) {
            return Optional.empty();
        }
        try {
            URI inputSchemaURI = new URI(workflow.getDataInputSchema().getSchema());
            return OpenApiModelSchemaGenerator.fromJsonSchemaToOpenApiSchema(workflow, inputSchemaURI.toString(), "");
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Invalid Data Input Schema for workflow {}. Only valid URIs are supported at this time.", (Object)workflow.getId());
            return Optional.empty();
        }
    }

    private static Optional<Schema> fromJsonSchemaToOpenApiSchema(Workflow workflow, String jsonSchemaURI, String authRef) {
        Optional<byte[]> bytes;
        if (jsonSchemaURI != null && (bytes = ServerlessWorkflowUtils.loadResourceFile(workflow, Optional.empty(), jsonSchemaURI, authRef)).isPresent()) {
            JSONObject rawSchema = new JSONObject(new JSONTokener(new String(bytes.get())));
            SchemaLoader schemaLoader = SchemaLoader.builder().schemaJson(rawSchema).resolutionScope(jsonSchemaURI).schemaClient(SchemaClient.classPathAwareClient()).build();
            try {
                ObjectMapper objectMapper = ObjectMapperFactory.get();
                return Optional.of((Schema)objectMapper.readValue(schemaLoader.load().build().toString(), JsonSchemaImpl.class));
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException("Error deserializing JSON Schema " + jsonSchemaURI + " for workflow " + workflow.getId(), (IOException)((Object)e));
            }
        }
        return Optional.empty();
    }

    public static Optional<OpenAPI> generateOpenAPIModelSchema(Workflow workflow) {
        return OpenApiModelSchemaGenerator.generateInputModel(workflow).map(inputModel -> OASFactory.createOpenAPI().components(OASFactory.createComponents().addSchema(workflow.getId(), inputModel)).openapi(workflow.getId() + "_workflowmodelschema"));
    }
}

