/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionRef;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.jackson.utils.JsonNodeVisitor;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;
import org.kie.kogito.process.workitems.WorkParametersFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.suppliers.ExpressionParametersFactorySupplier;
import org.kie.kogito.serverless.workflow.suppliers.ObjectResolverSupplier;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public abstract class WorkItemBuilder {
    protected <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> addFunctionArgs(Workflow workflow, WorkItemNodeFactory<T> node, FunctionRef functionRef) {
        JsonNode functionArgs = functionRef.getArguments();
        if (functionArgs != null) {
            this.processArgs(workflow, node, functionArgs, "_INPUT_MODEL");
        }
        return node;
    }

    protected WorkItemNodeFactory<?> buildWorkItem(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, ParserContext parserContext, String inputVar, String outputVar) {
        return (WorkItemNodeFactory)((WorkItemNodeFactory)embeddedSubProcess.workItemNode(parserContext.newId()).inMapping(inputVar, "_INPUT_MODEL")).outMapping("Result", outputVar);
    }

    protected final void processArgs(Workflow workflow, WorkItemNodeFactory<?> workItemFactory, JsonNode functionArgs, String paramName) {
        if (functionArgs.isObject()) {
            this.functionsToMap(workflow, functionArgs).forEach((key, value) -> this.processArg(workflow, (String)key, value, workItemFactory, paramName));
        } else {
            Object object = this.functionReference(workflow, JsonObjectUtils.simpleToJavaValue((JsonNode)functionArgs));
            if (this.isExpression(workflow, object)) {
                workItemFactory.workParameterFactory((WorkParametersFactory)new ExpressionParametersFactorySupplier(workflow.getExpressionLang(), object, paramName));
            } else {
                workItemFactory.workParameter("ContentData", object);
            }
        }
    }

    private Map<String, Object> functionsToMap(Workflow workflow, JsonNode jsonNode) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (jsonNode != null) {
            Iterator iter = jsonNode.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                map.put((String)entry.getKey(), this.functionReference(workflow, JsonObjectUtils.simpleToJavaValue((JsonNode)((JsonNode)entry.getValue()))));
            }
        }
        return map;
    }

    private Object functionReference(Workflow workflow, Object object) {
        if (object instanceof JsonNode) {
            return JsonNodeVisitor.transformTextNode((JsonNode)((JsonNode)object), node -> JsonObjectUtils.fromValue((Object)ExpressionHandlerUtils.replaceExpr((Workflow)workflow, (String)node.asText())));
        }
        if (object instanceof CharSequence) {
            return ExpressionHandlerUtils.replaceExpr((Workflow)workflow, (String)object.toString());
        }
        return object;
    }

    private void processArg(Workflow workflow, String key, Object value, WorkItemNodeFactory<?> workItemFactory, String paramName) {
        boolean isExpr = this.isExpression(workflow, value);
        ((WorkItemNodeFactory)workItemFactory.workParameter(key, isExpr ? new ObjectResolverSupplier(workflow.getExpressionLang(), value, paramName) : value)).workParameterDefinition(key, DataTypeResolver.fromObject((Object)value, (boolean)isExpr));
    }

    private boolean isExpression(Workflow workflow, Object value) {
        return value instanceof CharSequence && ExpressionHandlerFactory.get((String)workflow.getExpressionLang(), (String)value.toString()).isValid() || value instanceof JsonNode;
    }
}

