/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.schema;

import io.smallrye.openapi.api.util.MergeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jbpm.workflow.core.WorkflowModelValidator;
import org.jbpm.workflow.core.WorkflowProcess;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.serverless.workflow.parser.SwaggerSchemaProvider;

public final class OpenApiModelSchemaGenerator {
    private static final Schema ID_SCHEMA = OASFactory.createSchema();
    private static final String INPUT_SUFFIX = "_input";
    private static final String OUTPUT_SUFFIX = "_output";

    private OpenApiModelSchemaGenerator() {
    }

    public static Optional<OpenAPI> generateOpenAPIModelSchema(KogitoWorkflowProcess workflow) {
        if (workflow instanceof WorkflowProcess) {
            WorkflowProcess workflowProcess = (WorkflowProcess)workflow;
            Optional<SwaggerSchemaProvider> inputSchemaSupplier = OpenApiModelSchemaGenerator.getSchemaSupplier(workflowProcess.getInputValidator());
            Optional<SwaggerSchemaProvider> outputSchemaSupplier = OpenApiModelSchemaGenerator.getSchemaSupplier(workflowProcess.getOutputValidator());
            if (inputSchemaSupplier.isPresent() || outputSchemaSupplier.isPresent()) {
                OpenAPI openAPI = OASFactory.createOpenAPI().openapi(workflow.getId() + "_workflowmodelschema").components(OASFactory.createComponents());
                inputSchemaSupplier.ifPresent(v -> openAPI.getComponents().addSchema(OpenApiModelSchemaGenerator.getInputSchemaName(workflow.getId()), v.getSchema()));
                outputSchemaSupplier.ifPresent(v -> openAPI.getComponents().addSchema(OpenApiModelSchemaGenerator.getOutputSchemaName(workflow.getId()), OASFactory.createSchema().addProperty("workflowdata", v.getSchema()).addProperty("id", ID_SCHEMA)));
                return Optional.of(openAPI);
            }
        }
        return Optional.empty();
    }

    public static void mergeSchemas(OpenAPI targetSchema, Collection<OpenAPI> srcSchemas) {
        srcSchemas.forEach(srcSchema -> MergeUtil.merge((OpenAPI)targetSchema, (OpenAPI)srcSchema));
        if (targetSchema.getComponents() != null && targetSchema.getComponents().getSchemas() != null && targetSchema.getPaths() != null && targetSchema.getPaths().getPathItems() != null) {
            Map schemas = targetSchema.getComponents().getSchemas();
            for (PathItem pathItem : targetSchema.getPaths().getPathItems().values()) {
                OpenApiModelSchemaGenerator.processInputOperation(schemas, pathItem.getPOST());
                OpenApiModelSchemaGenerator.processInputOperation(schemas, pathItem.getPUT());
                OpenApiModelSchemaGenerator.processInputOperation(schemas, pathItem.getPATCH());
                OpenApiModelSchemaGenerator.processOutputOperation(schemas, pathItem.getGET());
            }
        }
    }

    private static Optional<SwaggerSchemaProvider> getSchemaSupplier(Optional<WorkflowModelValidator> validator) {
        return validator.filter(SwaggerSchemaProvider.class::isInstance).map(SwaggerSchemaProvider.class::cast);
    }

    private static String getInputSchemaName(String id) {
        return id + INPUT_SUFFIX;
    }

    private static String getOutputSchemaName(String id) {
        return id + OUTPUT_SUFFIX;
    }

    private static void processInputOperation(Map<String, Schema> schemas, Operation operation) {
        List tags;
        if (operation != null && operation.getRequestBody() != null && (tags = operation.getTags()) != null) {
            for (String tag : tags) {
                Schema schema = schemas.get(OpenApiModelSchemaGenerator.getInputSchemaName(tag));
                if (schema == null) continue;
                OpenApiModelSchemaGenerator.getMediaTypes(operation.getRequestBody().getContent()).forEach(mediaType -> mediaType.setSchema(schema));
            }
        }
    }

    private static void processOutputOperation(Map<String, Schema> schemas, Operation operation) {
        List tags;
        if (operation != null && operation.getResponses() != null && operation.getResponses().getAPIResponses() != null && (tags = operation.getTags()) != null) {
            for (String tag : tags) {
                Schema schema = schemas.get(OpenApiModelSchemaGenerator.getOutputSchemaName(tag));
                if (schema == null) continue;
                operation.getResponses().getAPIResponses().values().stream().flatMap(response -> OpenApiModelSchemaGenerator.getMediaTypes(response.getContent()).stream()).forEach(mediaType -> mediaType.setSchema(schema));
            }
        }
    }

    private static Collection<MediaType> getMediaTypes(Content content) {
        return content != null && content.getMediaTypes() != null ? content.getMediaTypes().values() : List.of();
    }

    static {
        ID_SCHEMA.setType(Schema.SchemaType.STRING);
        ID_SCHEMA.setDescription("Process instance id");
    }
}

