/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.types;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import java.util.Map;
import java.util.Optional;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.kie.kogito.serverless.workflow.asyncapi.AsyncChannelInfo;
import org.kie.kogito.serverless.workflow.asyncapi.AsyncInfo;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationId;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandler;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.VariableInfo;
import org.kie.kogito.serverless.workflow.parser.handlers.NodeFactoryUtils;
import org.kie.kogito.serverless.workflow.suppliers.ProduceEventActionSupplier;

public class AsyncAPITypeHandler
implements FunctionTypeHandler {
    @Override
    public String type() {
        return FunctionDefinition.Type.ASYNCAPI.toString();
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public NodeFactory<?, ?> getActionNode(Workflow workflow, ParserContext context, RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, FunctionDefinition functionDef, FunctionRef functionRef, VariableInfo varInfo) {
        WorkflowOperationId operationId = context.operationIdFactory().from(workflow, functionDef, Optional.of(context));
        return (NodeFactory)context.getAsyncInfoResolver().getAsyncInfo(operationId.getFileName()).flatMap(asyncAPI -> this.buildNode(workflow, context, embeddedSubProcess, functionDef, functionRef, varInfo, (AsyncInfo)asyncAPI, operationId.getOperation())).orElseThrow(() -> new IllegalArgumentException("Cannot find an async api with operation " + operationId.getOperation()));
    }

    private Optional<NodeFactory<?, ?>> buildNode(Workflow workflow, ParserContext context, RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, FunctionDefinition functionDef, FunctionRef functionRef, VariableInfo varInfo, AsyncInfo asyncInfo, String operationId) {
        for (Map.Entry<String, AsyncChannelInfo> entry : asyncInfo.getOperation2Channel().entrySet()) {
            if (!operationId.equals(entry.getKey())) continue;
            AsyncChannelInfo channelInfo = entry.getValue();
            return Optional.of(channelInfo.isPublish() ? this.buildPublishNode(workflow, context, embeddedSubProcess, functionDef, functionRef, varInfo, channelInfo) : this.buildSubscribeNode(context, embeddedSubProcess, functionDef, varInfo, channelInfo));
        }
        return Optional.empty();
    }

    private NodeFactory<?, ?> buildSubscribeNode(ParserContext context, RuleFlowNodeContainerFactory<?, ?> factory, FunctionDefinition functionDef, VariableInfo varInfo, AsyncChannelInfo entry) {
        return NodeFactoryUtils.consumeMessageNode(factory.eventNode(context.newId()), functionDef.getName(), entry.getName(), varInfo.getInputVar(), varInfo.getOutputVar());
    }

    private NodeFactory<?, ?> buildPublishNode(Workflow workflow, ParserContext context, RuleFlowNodeContainerFactory<?, ?> factory, FunctionDefinition functionDef, FunctionRef functionRef, VariableInfo varInfo, AsyncChannelInfo entry) {
        JsonNode args = functionRef.getArguments();
        return NodeFactoryUtils.sendEventNode(factory.actionNode(context.newId()).action((Action)new ProduceEventActionSupplier(workflow, args != null ? args.toString() : null)), functionDef.getName(), entry.getName(), varInfo.getInputVar());
    }
}

