/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.kie.kogito.serverless.workflow.io.ResourceCacheFactory;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;

public abstract class CachedContentLoader
implements URIContentLoader {
    private final URI uri;

    protected CachedContentLoader(URI uri) {
        this.uri = uri;
    }

    @Override
    public InputStream getInputStream() {
        return new NoCopyByteArrayInputStream(ResourceCacheFactory.getCache().get(this.uri, this::loadURI));
    }

    protected abstract byte[] loadURI(URI var1);

    @Override
    public URI uri() {
        return this.uri;
    }

    private static class NoCopyByteArrayInputStream
    extends ByteArrayInputStream {
        public NoCopyByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        @Override
        public synchronized byte[] readAllBytes() {
            if (this.pos == 0) {
                this.pos = this.count;
                return this.buf;
            }
            return super.readAllBytes();
        }
    }
}

