/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.defaultdef.DefaultConditionDefinition;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.states.SwitchState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.api.transitions.Transition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.parser.handlers.NodeFactoryUtils;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.validation.SwitchValidator;
import org.kie.kogito.serverless.workflow.utils.TimeoutsConfigResolver;

public class SwitchHandler
extends StateHandler<SwitchState> {
    private List<Runnable> targetHandlers = new ArrayList<Runnable>();

    protected SwitchHandler(SwitchState state, Workflow workflow, ParserContext parserContext) {
        super(state, workflow, parserContext);
    }

    @Override
    public boolean usedForCompensation() {
        return ((SwitchState)this.state).isUsedForCompensation();
    }

    @Override
    public MakeNodeResult makeNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        SwitchValidator.validateConditions((SwitchState)this.state, this.workflow);
        SplitFactory splitNode = factory.splitNode(this.parserContext.newId());
        splitNode = this.isDataBased() ? NodeFactoryUtils.exclusiveSplitNode(splitNode) : NodeFactoryUtils.eventBasedExclusiveSplitNode(splitNode);
        return new MakeNodeResult(splitNode.name(((SwitchState)this.state).getName()));
    }

    @Override
    protected void handleTransitions(RuleFlowNodeContainerFactory<?, ?> factory, Transition transition, NodeFactory<?, ?> sourceNode) {
        super.handleTransitions(factory, transition, sourceNode);
        if (this.isDataBased()) {
            this.finalizeDataBasedSwitchState(factory);
        } else {
            this.finalizeEventBasedSwitchState(factory);
        }
    }

    private boolean isDataBased() {
        return !((SwitchState)this.state).getDataConditions().isEmpty();
    }

    private void finalizeEventBasedSwitchState(final RuleFlowNodeContainerFactory<?, ?> factory) {
        NodeFactory<?, ?> splitNode = this.getNode();
        List conditions = ((SwitchState)this.state).getEventConditions();
        final DefaultConditionDefinition defaultCondition = ((SwitchState)this.state).getDefaultCondition();
        if (defaultCondition != null) {
            SwitchValidator.validateDefaultCondition(defaultCondition, (SwitchState)this.state, this.workflow, this.parserContext);
            final NodeFactory<?, ?> eventTimeoutTimerNode = this.connect(splitNode, (NodeFactory<?, ?>)NodeFactoryUtils.timerNode(factory.timerNode(this.parserContext.newId()), TimeoutsConfigResolver.resolveEventTimeout(this.state, this.workflow)));
            this.handleTransition(factory, defaultCondition.getTransition(), eventTimeoutTimerNode, Optional.of(new StateHandler.HandleTransitionCallBack(){

                @Override
                public void onEmptyTarget() {
                    SwitchHandler.this.endIt(eventTimeoutTimerNode.getNode().getId(), factory, defaultCondition.getEnd());
                }
            }));
        }
        for (final EventCondition eventCondition : conditions) {
            final NodeFactory<?, ?> outNode = this.connect(splitNode, this.filterAndMergeNode(factory, eventCondition.getEventDataFilter(), (f, inputVar, outputVar) -> this.consumeEventNode(f, eventCondition.getEventRef(), inputVar, outputVar)));
            this.handleTransition(factory, eventCondition.getTransition(), outNode, Optional.of(new StateHandler.HandleTransitionCallBack(){

                @Override
                public void onEmptyTarget() {
                    SwitchHandler.this.endIt(outNode.getNode().getId(), factory, eventCondition.getEnd());
                }
            }));
        }
    }

    private void finalizeDataBasedSwitchState(final RuleFlowNodeContainerFactory<?, ?> factory) {
        final NodeFactory<?, ?> startNode = this.getNode();
        final long splitId = startNode.getNode().getId();
        final DefaultConditionDefinition defaultCondition = ((SwitchState)this.state).getDefaultCondition();
        if (defaultCondition != null) {
            SwitchValidator.validateDefaultCondition(defaultCondition, (SwitchState)this.state, this.workflow, this.parserContext);
            this.handleTransition(factory, defaultCondition.getTransition(), startNode, Optional.of(new StateHandler.HandleTransitionCallBack(){

                @Override
                public void onStateTarget(StateHandler<?> targetState) {
                    SwitchHandler.this.targetHandlers.add(() -> startNode.metaData("Default", (Object)StateHandler.concatId(splitId, targetState.getIncomingNode(factory).getNode().getId())));
                }

                @Override
                public void onIdTarget(long targetId) {
                    startNode.metaData("Default", (Object)StateHandler.concatId(splitId, targetId));
                }

                @Override
                public void onEmptyTarget() {
                    NodeFactory<?, ?> endNodeFactory = SwitchHandler.this.endIt(splitId, factory, defaultCondition.getEnd());
                    startNode.metaData("Default", (Object)StateHandler.concatId(splitId, endNodeFactory.getNode().getId()));
                }
            }));
        }
        List conditions = ((SwitchState)this.state).getDataConditions();
        for (final DataCondition condition : conditions) {
            this.handleTransition(factory, condition.getTransition(), startNode, Optional.of(new StateHandler.HandleTransitionCallBack(){

                @Override
                public void onStateTarget(StateHandler<?> targetState) {
                    SwitchHandler.this.targetHandlers.add(() -> SwitchHandler.this.addConstraint(factory, startNode, targetState, condition));
                }

                @Override
                public void onIdTarget(long targetId) {
                    SwitchHandler.this.addConstraint(startNode, targetId, condition);
                }

                @Override
                public void onEmptyTarget() {
                    NodeFactory<?, ?> endNodeFactory = SwitchHandler.this.endIt(splitId, factory, condition.getEnd());
                    SwitchHandler.this.addConstraint(startNode, endNodeFactory.getNode().getId(), condition);
                }
            }));
        }
    }

    private NodeFactory<?, ?> endIt(long sourceNodeId, RuleFlowNodeContainerFactory<?, ?> factory, End end) {
        NodeFactory<?, ?> endNodeFactory = this.endNodeFactory(factory, end);
        endNodeFactory.done().connection(sourceNodeId, endNodeFactory.getNode().getId());
        return endNodeFactory;
    }

    private void addConstraint(RuleFlowNodeContainerFactory<?, ?> factory, NodeFactory<?, ?> startNode, StateHandler<?> stateHandler, DataCondition condition) {
        this.addConstraint(startNode, stateHandler.getIncomingNode(factory).getNode().getId(), condition);
    }

    private void addConstraint(NodeFactory<?, ?> startNode, long targetId, DataCondition condition) {
        this.addCondition((SplitFactory)startNode, targetId, condition.getCondition(), SwitchHandler.isDefaultCondition((SwitchState)this.state, condition));
    }

    private static boolean isDefaultCondition(SwitchState switchState, DataCondition condition) {
        return switchState.getDefaultCondition() != null && (switchState.getDefaultCondition().getTransition() != null && condition.getTransition() != null && condition.getTransition().getNextState().equals(switchState.getDefaultCondition().getTransition().getNextState()) || switchState.getDefaultCondition().getEnd() != null && condition.getEnd() != null);
    }

    @Override
    public void handleConnections() {
        super.handleConnections();
        this.targetHandlers.forEach(Runnable::run);
    }
}

