/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import org.kie.kogito.serverless.workflow.io.CachedContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;

public class FileContentLoader
extends CachedContentLoader {
    private final Path path;

    FileContentLoader(URI uri) {
        super(uri);
        this.path = Path.of(FileContentLoader.getPath(uri), new String[0]);
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public URIContentLoaderType type() {
        return URIContentLoaderType.FILE;
    }

    @Override
    protected byte[] loadURI(URI uri) {
        try {
            return Files.readAllBytes(this.path);
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
    }

    static String getPath(URI uri) {
        return uri.getPath();
    }
}

