/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.branches.Branch;
import io.serverlessworkflow.api.states.ParallelState;
import java.util.Iterator;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.CompositeContextNodeHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.suppliers.ExpressionReturnValueEvaluatorSupplier;

public class ParallelHandler
extends CompositeContextNodeHandler<ParallelState> {
    private Branch currentBranch;

    protected ParallelHandler(ParallelState state, Workflow workflow, ParserContext parserContext) {
        super(state, workflow, parserContext);
    }

    @Override
    public MakeNodeResult makeNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        SplitFactory nodeFactory = ((SplitFactory)factory.splitNode(this.parserContext.newId()).name(((ParallelState)this.state).getName() + "Start")).type(1);
        JoinFactory connectionNode = factory.joinNode(this.parserContext.newId()).name(((ParallelState)this.state).getName() + "End");
        ParallelState.CompletionType completionType = ((ParallelState)this.state).getCompletionType();
        if (completionType == ParallelState.CompletionType.ALL_OF) {
            connectionNode.type(1);
        } else if (completionType == ParallelState.CompletionType.AT_LEAST) {
            String numCompleted = ((ParallelState)this.state).getNumCompleted();
            connectionNode.type(4);
            connectionNode.type(numCompleted);
            if (ExpressionHandlerFactory.get((String)this.workflow.getExpressionLang(), (String)numCompleted).isValid()) {
                connectionNode.metaData("Action", (Object)new ExpressionReturnValueEvaluatorSupplier(this.workflow.getExpressionLang(), ((ParallelState)this.state).getNumCompleted(), "workflowdata", Integer.class));
            }
        }
        Iterator iterator = ((ParallelState)this.state).getBranches().iterator();
        while (iterator.hasNext()) {
            Branch branch;
            this.currentBranch = branch = (Branch)iterator.next();
            CompositeContextNodeFactory<?> embeddedSubProcess = this.handleActions(this.makeCompositeNode(factory, this.getName(branch)), branch.getActions());
            long branchId = embeddedSubProcess.getNode().getId();
            embeddedSubProcess.done().connection(nodeFactory.getNode().getId(), branchId).connection(branchId, connectionNode.getNode().getId());
        }
        return new MakeNodeResult((NodeFactory<?, ?>)nodeFactory, (NodeFactory<?, ?>)connectionNode);
    }

    private String getName(Branch branch) {
        StringBuilder sb = new StringBuilder(((ParallelState)this.state).getName());
        String branchName = branch.getName();
        if (branchName != null && !branchName.isBlank()) {
            sb.append('-').append(branchName);
        }
        return sb.toString();
    }

    @Override
    protected NodeFactory<?, ?> addActionMetadata(NodeFactory<?, ?> node, Action action) {
        node = super.addActionMetadata(node, action);
        if (this.currentBranch != null && this.currentBranch.getName() != null) {
            node.metaData("branch", (Object)this.currentBranch.getName());
        }
        return node;
    }

    @Override
    public boolean usedForCompensation() {
        return ((ParallelState)this.state).isUsedForCompensation();
    }
}

