/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.interfaces.State;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.EventNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.kie.api.definition.process.Process;
import org.kie.kogito.serverless.workflow.parser.DefaultNodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.NodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandlerFactory;
import org.kie.kogito.serverless.workflow.parser.util.ServerlessWorkflowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerlessWorkflowParser {
    private static final Logger logger = LoggerFactory.getLogger(ServerlessWorkflowParser.class);
    public static final String NODE_START_NAME = "Start";
    public static final String NODE_END_NAME = "End";
    public static final String DEFAULT_NAME = "workflow";
    public static final String DEFAULT_PACKAGE = "org.kie.kogito.serverless";
    public static final String DEFAULT_VERSION = "1.0";
    public static final String JSON_NODE = "com.fasterxml.jackson.databind.JsonNode";
    public static final String DEFAULT_WORKFLOW_VAR = "workflowdata";
    private NodeIdGenerator idGenerator = DefaultNodeIdGenerator.get();
    private Workflow workflow;
    private Process process;

    public static ServerlessWorkflowParser of(Reader workflowFile, String workflowFormat) throws JsonProcessingException {
        return ServerlessWorkflowParser.of((Workflow)ServerlessWorkflowUtils.getObjectMapper(workflowFormat).readValue(ServerlessWorkflowUtils.readWorkflowFile(workflowFile), Workflow.class));
    }

    public static ServerlessWorkflowParser of(Workflow workflow) {
        return new ServerlessWorkflowParser(workflow);
    }

    public ServerlessWorkflowParser withIdGenerator(NodeIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    private ServerlessWorkflowParser(Workflow workflow) {
        this.workflow = workflow;
    }

    private Process parseProcess() {
        String workflowStartStateName = this.workflow.getStart().getStateName();
        if (workflowStartStateName == null || workflowStartStateName.trim().isEmpty()) {
            throw new IllegalArgumentException("workflow does not define a starting state");
        }
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)this.workflow.getId()).name(this.workflow.getName() == null ? DEFAULT_NAME : this.workflow.getName()).version(this.workflow.getVersion() == null ? DEFAULT_VERSION : this.workflow.getVersion()).packageName(this.workflow.getMetadata() != null ? this.workflow.getMetadata().getOrDefault("package", DEFAULT_PACKAGE) : DEFAULT_PACKAGE).visibility("Public").variable(DEFAULT_WORKFLOW_VAR, JsonNode.class);
        LinkedHashMap stateHandlers = new LinkedHashMap();
        for (State state : this.workflow.getStates()) {
            StateHandler stateHandler = StateHandlerFactory.getStateHandler(state, this.workflow, factory, this.idGenerator);
            if (stateHandler == null) {
                logger.warn("Unsupported state {}. Ignoring it", (Object)state.getName());
                continue;
            }
            stateHandlers.put(state.getName(), stateHandler);
            stateHandler.handleStart(workflowStartStateName);
        }
        stateHandlers.values().forEach(StateHandler::handleEnd);
        stateHandlers.values().forEach(StateHandler::handleState);
        stateHandlers.values().forEach(s -> s.handleTransitions(stateHandlers));
        return factory.validate().getProcess();
    }

    public Process getProcess() {
        if (this.process == null) {
            this.process = this.parseProcess();
        }
        return this.process;
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> StartNodeFactory<T> messageStartNode(StartNodeFactory<T> nodeFactory, EventDefinition eventDefinition) {
        return ((StartNodeFactory)((StartNodeFactory)((StartNodeFactory)((StartNodeFactory)((StartNodeFactory)nodeFactory.name(eventDefinition.getName())).metaData("TriggerMapping", (Object)DEFAULT_WORKFLOW_VAR)).metaData("TriggerType", (Object)"ConsumeMessage")).metaData("TriggerRef", (Object)eventDefinition.getType())).metaData("MessageType", (Object)JSON_NODE)).trigger(JSON_NODE, DEFAULT_WORKFLOW_VAR);
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> SubProcessNodeFactory<T> subprocessNode(SubProcessNodeFactory<T> nodeFactory) {
        Map<String, String> types = Collections.singletonMap(DEFAULT_WORKFLOW_VAR, JSON_NODE);
        VariableScope variableScope = new VariableScope();
        return (SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)((SubProcessNodeFactory)nodeFactory.independent(true).metaData("BPMN.InputTypes", types)).metaData("BPMN.OutputTypes", types)).inMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR)).outMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR)).context((Context)variableScope)).defaultContext((Context)variableScope);
    }

    public static <T extends NodeFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>> NodeFactory<T, P> sendEventNode(NodeFactory<T, P> actionNode, EventDefinition eventDefinition) {
        return actionNode.name(eventDefinition.getName()).metaData("TriggerType", (Object)"ProduceMessage").metaData("MappingVariable", (Object)DEFAULT_WORKFLOW_VAR).metaData("TriggerRef", (Object)eventDefinition.getType()).metaData("MessageType", (Object)JSON_NODE);
    }

    public static <T extends RuleFlowNodeContainerFactory<T, ?>> EventNodeFactory<T> consumeEventNode(EventNodeFactory<T> eventNode, EventDefinition eventDefinition) {
        return (EventNodeFactory)((EventNodeFactory)((EventNodeFactory)((EventNodeFactory)((EventNodeFactory)((EventNodeFactory)((EventNodeFactory)eventNode.name(eventDefinition.getName())).variableName(DEFAULT_WORKFLOW_VAR)).metaData("EventType", (Object)"message")).metaData("TriggerRef", (Object)eventDefinition.getType())).metaData("MessageType", (Object)JSON_NODE)).metaData("TriggerType", (Object)"ConsumeMessage")).eventType("Message-" + eventDefinition.getType());
    }
}

