/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.transitions.Transition;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.actions.HandleMessageAction;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.kie.kogito.serverless.workflow.parser.NodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.ServerlessWorkflowParser;
import org.kie.kogito.serverless.workflow.parser.util.ServerlessWorkflowUtils;

public abstract class StateHandler<S extends State, T extends NodeFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>> {
    protected final S state;
    protected final Workflow workflow;
    protected final RuleFlowNodeContainerFactory<P, ?> factory;
    protected final NodeIdGenerator idGenerator;
    private StartNodeFactory<P> startNodeFactory;
    private EndNodeFactory<P> endNodeFactory;
    private T node;

    protected StateHandler(S state, Workflow workflow, RuleFlowNodeContainerFactory<P, ?> factory, NodeIdGenerator idGenerator) {
        this.workflow = workflow;
        this.factory = factory;
        this.state = state;
        this.idGenerator = idGenerator;
    }

    public void handleStart(String startState) {
        if (this.state.getName().equals(startState)) {
            this.startNodeFactory = (StartNodeFactory)this.factory.startNode(this.idGenerator.getId()).name("Start");
            this.startNodeFactory.done();
        }
    }

    public void handleEnd() {
        if (this.state.getEnd() != null) {
            this.endNodeFactory = (EndNodeFactory)this.factory.endNode(this.idGenerator.getId()).name("End");
            List produceEvents = this.state.getEnd().getProduceEvents();
            if (produceEvents == null || produceEvents.isEmpty()) {
                this.endNodeFactory.terminate(true);
            } else {
                ServerlessWorkflowParser.sendEventNode(this.endNodeFactory.terminate(false).action((Action)new HandleMessageAction("com.fasterxml.jackson.databind.JsonNode", "workflowdata")), ServerlessWorkflowUtils.getWorkflowEventFor(this.workflow, ((ProduceEvent)produceEvents.get(0)).getEventRef()));
            }
            this.endNodeFactory.done();
        }
    }

    public void handleState() {
        this.node = this.makeNode();
        this.node.done();
        this.connectStart();
        this.connectEnd();
    }

    public void handleTransitions(Map<String, StateHandler<?, ?, ?>> stateConnection) {
        this.handleTransition(this.state.getTransition(), this.getConnectionNode().getNode().getId(), stateConnection);
    }

    protected void connectStart() {
        if (this.startNodeFactory != null) {
            this.factory.connection(this.startNodeFactory.getNode().getId(), this.node.getNode().getId());
        }
    }

    protected void connectEnd() {
        if (this.endNodeFactory != null) {
            this.factory.connection(this.getConnectionNode().getNode().getId(), this.endNodeFactory.getNode().getId());
        }
    }

    public T getNode() {
        return this.node;
    }

    public S getState() {
        return this.state;
    }

    public <N extends NodeFactory<N, P>> N getConnectionNode() {
        return (N)this.getNode();
    }

    protected abstract T makeNode();

    protected Optional<Long> handleTransition(Transition transition, long sourceId, Map<String, StateHandler<?, ?, ?>> stateConnection) {
        if (transition != null && transition.getNextState() != null) {
            ActionNodeFactory actionNode;
            long targetId = stateConnection.get(transition.getNextState()).getNode().getNode().getId();
            List produceEvents = transition.getProduceEvents();
            if (produceEvents.isEmpty()) {
                this.factory.connection(sourceId, targetId);
                return Optional.of(targetId);
            }
            ActionNodeFactory endNode = actionNode = this.factory.actionNode(this.idGenerator.getId());
            ServerlessWorkflowParser.sendEventNode(actionNode, ServerlessWorkflowUtils.getWorkflowEventFor(this.workflow, ((ProduceEvent)produceEvents.get(0)).getEventRef()));
            if (produceEvents.size() > 1) {
                ListIterator iter = produceEvents.listIterator(1);
                while (iter.hasNext()) {
                    ProduceEvent produceEvent = (ProduceEvent)iter.next();
                    ActionNodeFactory newNode = this.factory.actionNode(this.idGenerator.getId());
                    ServerlessWorkflowParser.sendEventNode(newNode, ServerlessWorkflowUtils.getWorkflowEventFor(this.workflow, produceEvent.getEventRef())).done().connection(endNode.getNode().getId(), newNode.getNode().getId());
                    endNode = newNode;
                }
            }
            this.factory.connection(sourceId, actionNode.getNode().getId());
            this.factory.connection(endNode.getNode().getId(), targetId);
            return Optional.of(actionNode.getNode().getId());
        }
        return Optional.empty();
    }
}

