/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.workflow.Functions;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jbpm.compiler.canonical.descriptors.OpenApiTaskDescriptor;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.serverless.workflow.parser.NodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.util.ServerlessWorkflowUtils;
import org.kie.kogito.serverless.workflow.parser.util.WorkflowAppContext;
import org.kie.kogito.serverless.workflow.suppliers.JsonPathExprSupplier;
import org.kie.kogito.serverless.workflow.suppliers.RestBodyBuilderSupplier;
import org.kogito.workitem.openapi.JsonNodeParameterResolver;
import org.kogito.workitem.openapi.JsonNodeResultHandler;
import org.kogito.workitem.openapi.suppliers.JsonNodeParameterExprSupplier;
import org.kogito.workitem.openapi.suppliers.JsonNodeResultHandlerExprSupplier;

public abstract class CompositeContextNodeHandler<S extends State, P extends RuleFlowNodeContainerFactory<P, ?>>
extends StateHandler<S, CompositeContextNodeFactory<P>, P> {
    private static final String SCRIPT_TYPE = "script";
    private static final String REST_TYPE = "rest";
    private static final String SCRIPT_TYPE_PARAM = "script";
    private static final String SYSOUT_TYPE = "sysout";
    private static final String SYSOUT_TYPE_PARAM = "message";
    private static final String SERVICE_TYPE = "service";
    private static final String SERVICE_TASK_TYPE = "Service Task";
    private static final String WORKITEM_INTERFACE = "Interface";
    private static final String WORKITEM_OPERATION = "Operation";
    private static final String WORKITEM_INTERFACE_IMPL = "interfaceImplementationRef";
    private static final String WORKITEM_OPERATION_IMPL = "operationImplementationRef";
    private static final String WORKITEM_PARAM_TYPE = "ParameterType";
    private static final String WORKITEM_PARAM = "Parameter";
    private static final String WORKITEM_RESULT = "Result";
    private static final String SERVICE_INTERFACE_KEY = "interface";
    private static final String SERVICE_OPERATION_KEY = "operation";
    private static final String SERVICE_IMPL_KEY = "implementation";
    private final WorkflowAppContext workflowAppContext = WorkflowAppContext.ofAppResources();

    protected CompositeContextNodeHandler(S state, Workflow workflow, RuleFlowNodeContainerFactory<P, ?> factory, NodeIdGenerator idGenerator) {
        super(state, workflow, factory, idGenerator);
    }

    protected final CompositeContextNodeFactory<P> handleActions(CompositeContextNodeFactory<P> embeddedSubProcess, Functions workflowFunctions, List<Action> actions) {
        if (actions != null && !actions.isEmpty() && workflowFunctions != null) {
            NodeFactory<?, ?> startNode;
            NodeFactory<?, ?> currentNode = startNode = embeddedSubProcess.startNode(this.idGenerator.getId()).name("EmbeddedStart");
            for (Action action : actions) {
                currentNode = this.getCurrentNode(embeddedSubProcess, workflowFunctions, action);
                embeddedSubProcess.connection(startNode.getNode().getId(), currentNode.getNode().getId());
                startNode = currentNode;
            }
            long endId = this.idGenerator.getId();
            ((CompositeContextNodeFactory)((EndNodeFactory)embeddedSubProcess.endNode(endId).name("EmbeddedEnd")).terminate(true).done()).connection(currentNode.getNode().getId(), endId);
        } else {
            long startId = this.idGenerator.getId();
            long endId = this.idGenerator.getId();
            ((CompositeContextNodeFactory)((EndNodeFactory)((CompositeContextNodeFactory)((StartNodeFactory)embeddedSubProcess.startNode(startId).name("EmbeddedStart")).done()).endNode(endId).name("EmbeddedEnd")).terminate(true).done()).connection(startId, endId);
        }
        return embeddedSubProcess;
    }

    private NodeFactory<?, ?> getCurrentNode(CompositeContextNodeFactory<P> embeddedSubProcess, Functions workflowFunctions, Action action) {
        String actionName = action.getFunctionRef().getRefName();
        FunctionDefinition actionFunction = workflowFunctions.getFunctionDefs().stream().filter(wf -> wf.getName().equals(actionName)).findFirst().orElseThrow(() -> new IllegalArgumentException("cannot find function " + actionName));
        switch (this.getActionType(actionFunction)) {
            case SCRIPT: {
                return embeddedSubProcess.actionNode(this.idGenerator.getId()).name(actionName).action("java", ServerlessWorkflowUtils.scriptFunctionScript(action.getFunctionRef().getArguments().get("script").asText()));
            }
            case SYSOUT: {
                return embeddedSubProcess.actionNode(this.idGenerator.getId()).name(actionName).action("java", ServerlessWorkflowUtils.sysOutFunctionScript(action.getFunctionRef().getArguments().get(SYSOUT_TYPE_PARAM).asText()));
            }
            case SERVICE: {
                return ((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)embeddedSubProcess.workItemNode(this.idGenerator.getId()).name(actionName)).metaData("Type", (Object)SERVICE_TASK_TYPE)).workName(SERVICE_TASK_TYPE)).workParameter(WORKITEM_INTERFACE, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_INTERFACE_KEY, this.workflowAppContext))).workParameter(WORKITEM_OPERATION, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_OPERATION_KEY, this.workflowAppContext))).workParameter(WORKITEM_INTERFACE_IMPL, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_INTERFACE_KEY, this.workflowAppContext))).workParameter(WORKITEM_OPERATION_IMPL, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_OPERATION_KEY, this.workflowAppContext))).workParameter(WORKITEM_PARAM_TYPE, (Object)"com.fasterxml.jackson.databind.JsonNode")).workParameter(SERVICE_IMPL_KEY, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, SERVICE_IMPL_KEY, this.workflowAppContext, "Java"))).inMapping(WORKITEM_PARAM, "workflowdata")).outMapping(WORKITEM_PARAM, "workflowdata");
            }
            case REST: {
                JsonNode arguments;
                ObjectMapper mapper;
                Map mapArguments;
                WorkItemNodeFactory workItemFactory = (WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)embeddedSubProcess.workItemNode(this.idGenerator.getId()).name(actionFunction.getName())).metaData("Type", (Object)"Rest")).workName("Rest")).workParameter("Url", (Object)actionFunction.getOperation())).workParameter("Method", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, "method", this.workflowAppContext))).workParameter("Username", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, "user", this.workflowAppContext))).workParameter("Password", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, "password", this.workflowAppContext))).workParameter("Host", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(actionFunction, "host", this.workflowAppContext))).workParameter("Port", (Object)ServerlessWorkflowUtils.resolveFunctionMetadataAsInt(actionFunction, "port", this.workflowAppContext))).workParameter("BodyBuilder", (Object)new RestBodyBuilderSupplier())).inMapping("ContentData", "workflowdata")).outMapping(WORKITEM_RESULT, "workflowdata");
                FunctionRef functionRef = action.getFunctionRef();
                if (functionRef.getArguments() != null && (mapArguments = (Map)(mapper = new ObjectMapper()).convertValue((Object)(arguments = functionRef.getArguments()), (TypeReference)new TypeReference<Map<String, String>>(){})) != null) {
                    for (Map.Entry param : mapArguments.entrySet()) {
                        workItemFactory.workParameter((String)param.getKey(), (Object)new JsonPathExprSupplier((String)param.getValue()));
                    }
                }
                return workItemFactory;
            }
            case OPENAPI: {
                OpenApiTaskDescriptor.WorkItemBuilder builder = OpenApiTaskDescriptor.builderFor((String)ServerlessWorkflowUtils.getOpenApiURI(actionFunction), (String)ServerlessWorkflowUtils.getOpenApiOperationId(actionFunction)).withParamResolverType(JsonNodeParameterResolver.class.getCanonicalName()).withResultHandlerType(JsonNodeResultHandler.class.getCanonicalName()).withResultHandler((Supplier)new JsonNodeResultHandlerExprSupplier());
                JsonNode arguments = action.getFunctionRef().getArguments();
                ObjectMapper mapper = new ObjectMapper();
                Map mapArguments = (Map)mapper.convertValue((Object)arguments, (TypeReference)new TypeReference<Map<String, String>>(){});
                if (mapArguments != null) {
                    mapArguments.forEach((k, v) -> builder.addParamResolver(k, (Supplier)new JsonNodeParameterExprSupplier(v)));
                }
                return ((WorkItemNodeFactory)((WorkItemNodeFactory)builder.build(embeddedSubProcess.workItemNode(this.idGenerator.getId())).name(action.getFunctionRef().getRefName())).inMapping(WORKITEM_PARAM, "workflowdata")).outMapping(WORKITEM_RESULT, "workflowdata");
            }
        }
        return this.emptyNode(embeddedSubProcess, actionName);
    }

    private ActionType getActionType(FunctionDefinition actionFunction) {
        String type;
        if (ServerlessWorkflowUtils.isOpenApiOperation(actionFunction)) {
            return ActionType.OPENAPI;
        }
        String string = type = actionFunction.getMetadata() != null ? (String)actionFunction.getMetadata().get("type") : null;
        if (SERVICE_TYPE.equalsIgnoreCase(type)) {
            return ActionType.SERVICE;
        }
        if ("script".equalsIgnoreCase(type)) {
            return ActionType.SCRIPT;
        }
        if (SYSOUT_TYPE.equalsIgnoreCase(type)) {
            return ActionType.SYSOUT;
        }
        if (REST_TYPE.equalsIgnoreCase(type)) {
            return ActionType.REST;
        }
        return ActionType.EMPTY;
    }

    private NodeFactory<?, ?> emptyNode(CompositeContextNodeFactory<P> embeddedSubProcess, String actionName) {
        return embeddedSubProcess.actionNode(this.idGenerator.getId()).name(actionName).action("java", ServerlessWorkflowUtils.scriptFunctionScript(""));
    }

    private static enum ActionType {
        REST,
        SERVICE,
        OPENAPI,
        SCRIPT,
        SYSOUT,
        EMPTY;

    }
}

