/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.states.SwitchState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.api.transitions.Transition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.kie.kogito.serverless.workflow.parser.NodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.ServerlessWorkflowParser;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.util.ServerlessWorkflowUtils;

public class SwitchHandler<P extends RuleFlowNodeContainerFactory<P, ?>>
extends StateHandler<SwitchState, SplitFactory<P>, P> {
    private static final String XORSPLITDEFAULT = "Default";

    protected SwitchHandler(SwitchState state, Workflow workflow, RuleFlowNodeContainerFactory<P, ?> factory, NodeIdGenerator idGenerator) {
        super(state, workflow, factory, idGenerator);
    }

    @Override
    public SplitFactory<P> makeNode() {
        long id = this.idGenerator.getId();
        SplitFactory splitFactory = (SplitFactory)this.factory.splitNode(id).name(((SwitchState)this.state).getName());
        if (!((SwitchState)this.state).getDataConditions().isEmpty()) {
            splitFactory.type(2);
        } else {
            splitFactory.type(4);
            splitFactory.metaData("UniqueId", (Object)Long.toString(id));
            splitFactory.metaData("EventBased", (Object)"true");
        }
        return splitFactory;
    }

    @Override
    public void handleTransitions(Map<String, StateHandler<?, ?, ?>> stateConnection) {
        super.handleTransitions(stateConnection);
        StateHandler<?, ?, ?> connInfo = stateConnection.get(((SwitchState)this.state).getName());
        if (connInfo == null) {
            throw new IllegalStateException("unable to get split node for switch state }" + ((SwitchState)this.state).getName());
        }
        if (!((SwitchState)this.state).getDataConditions().isEmpty()) {
            this.finalizeDataBasedSwitchState((NodeFactory<?, ?>)connInfo.getNode(), stateConnection);
        } else {
            this.finalizeEventBasedSwitchState((NodeFactory<?, ?>)connInfo.getNode(), stateConnection);
        }
    }

    private void finalizeEventBasedSwitchState(NodeFactory<?, ?> startNode, Map<String, StateHandler<?, ?, ?>> stateConnection) {
        List conditions = ((SwitchState)this.state).getEventConditions();
        for (EventCondition eventCondition : conditions) {
            EventDefinition eventDefinition = ServerlessWorkflowUtils.getWorkflowEventFor(this.workflow, eventCondition.getEventRef());
            long targetId = stateConnection.get(eventCondition.getTransition().getNextState()).getNode().getNode().getId();
            long eventId = this.idGenerator.getId();
            ServerlessWorkflowParser.consumeEventNode(this.factory.eventNode(eventId), eventDefinition).done().connection(startNode.getNode().getId(), eventId).connection(eventId, targetId);
        }
    }

    private void finalizeDataBasedSwitchState(NodeFactory<?, ?> startNode, Map<String, StateHandler<?, ?, ?>> stateConnection) {
        long splitId = startNode.getNode().getId();
        if (((SwitchState)this.state).getDefault() != null) {
            Transition transition = ((SwitchState)this.state).getDefault().getTransition();
            if (transition != null && transition.getNextState() != null) {
                startNode.metaData(XORSPLITDEFAULT, (Object)SwitchHandler.concatId(splitId, stateConnection.get(transition.getNextState()).getNode().getNode().getId()));
            } else if (((SwitchState)this.state).getDefault().getEnd() != null) {
                EndNodeFactory<P> endNodeFactory = this.endNodeFactory(((SwitchState)this.state).getDefault().getEnd().getProduceEvents());
                endNodeFactory.done().connection(splitId, endNodeFactory.getNode().getId());
                startNode.metaData(XORSPLITDEFAULT, (Object)SwitchHandler.concatId(splitId, endNodeFactory.getNode().getId()));
            }
        }
        List conditions = ((SwitchState)this.state).getDataConditions();
        for (DataCondition condition : conditions) {
            Optional<Long> targetId = this.handleTransition(condition.getTransition(), splitId, stateConnection);
            if (!targetId.isPresent() && condition.getEnd() != null) {
                EndNodeFactory<P> endNodeFactory = this.endNodeFactory(condition.getEnd().getProduceEvents());
                endNodeFactory.done().connection(splitId, endNodeFactory.getNode().getId());
                targetId = Optional.of(endNodeFactory.getNode().getId());
            }
            if (targetId.isPresent()) {
                ((SplitFactory)startNode).constraint(targetId.get().longValue(), SwitchHandler.concatId(splitId, targetId.get()), "DROOLS_DEFAULT", "java", ServerlessWorkflowUtils.conditionScript(condition.getCondition()), 0, SwitchHandler.isDefaultCondition((SwitchState)this.state, condition));
                continue;
            }
            throw new IllegalArgumentException("Invalid condition, not transition not end");
        }
    }

    private EndNodeFactory<P> endNodeFactory(List<ProduceEvent> produceEvents) {
        EndNodeFactory endNodeFactory = this.factory.endNode(this.idGenerator.getId());
        if (produceEvents == null || produceEvents.isEmpty()) {
            endNodeFactory.terminate(true);
        } else {
            ServerlessWorkflowParser.sendEventNode(endNodeFactory, ServerlessWorkflowUtils.getWorkflowEventFor(this.workflow, produceEvents.get(0).getEventRef()));
        }
        return endNodeFactory;
    }

    private static String concatId(long start, long end) {
        return start + "_" + end;
    }

    private static boolean isDefaultCondition(SwitchState switchState, DataCondition condition) {
        return switchState.getDefault() != null && (switchState.getDefault().getTransition() != null && condition.getTransition() != null && condition.getTransition().getNextState().equals(switchState.getDefault().getTransition().getNextState()) || switchState.getDefault().getEnd() != null && condition.getEnd() != null);
    }
}

