/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.CachedContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;

public class ClassPathContentLoader
extends CachedContentLoader {
    private final Optional<URL> resource;
    private final String classpath;

    ClassPathContentLoader(URI uri, Optional<ClassLoader> cl, URIContentLoader ... fallbackContentLoaders) {
        super(uri, fallbackContentLoaders);
        this.classpath = ClassPathContentLoader.getPath(uri);
        this.resource = Optional.ofNullable(cl.orElse(Thread.currentThread().getContextClassLoader()).getResource(this.classpath));
    }

    static String getPath(URI uri) {
        String classPathPrefix = "classpath:";
        String str = URLDecoder.decode(uri.toString(), Charset.defaultCharset());
        if (str.toLowerCase().startsWith("classpath:")) {
            str = str.substring("classpath:".length());
            while (str.startsWith("/")) {
                str = str.substring(1);
            }
        }
        return str;
    }

    public Optional<URL> getResource() {
        return this.resource;
    }

    @Override
    protected Optional<Path> internalGetPath() {
        return this.resource.map(ClassPathContentLoader::fromURL);
    }

    String classpath() {
        return this.classpath;
    }

    private static Path fromURL(URL url) {
        try {
            return Path.of(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI " + url, e);
        }
    }

    @Override
    protected byte[] loadURI(URI uri) {
        return this.resource.map(this::loadBytes).orElseThrow(() -> new IllegalArgumentException("cannot find classpath resource " + this.classpath));
    }

    private byte[] loadBytes(URL r) {
        byte[] byArray;
        block8: {
            InputStream is = r.openStream();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            }
            is.close();
        }
        return byArray;
    }

    @Override
    public URIContentLoaderType type() {
        return URIContentLoaderType.CLASSPATH;
    }
}

