/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import io.serverlessworkflow.api.Workflow;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.ClassPathContentLoader;
import org.kie.kogito.serverless.workflow.io.FileContentLoader;
import org.kie.kogito.serverless.workflow.io.HttpContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class URIContentLoaderFactory {
    public static byte[] readAllBytes(URIContentLoader loader) {
        byte[] byArray;
        block8: {
            InputStream is = loader.getInputStream();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static byte[] readAllBytes(Builder builder) {
        return URIContentLoaderFactory.readAllBytes(builder.build());
    }

    public static String readString(URIContentLoader loader) {
        return new String(URIContentLoaderFactory.readAllBytes(loader));
    }

    public static String getFileName(URI uri) {
        URIContentLoaderType type = URIContentLoaderType.from(uri);
        String path = URIContentLoaderFactory.uriToPath(type, uri);
        return type.lastPart(path);
    }

    private static String uriToPath(URIContentLoaderType type, URI uri) {
        switch (type) {
            case CLASSPATH: {
                return ClassPathContentLoader.getPath(uri);
            }
            case FILE: {
                return FileContentLoader.getPath(uri);
            }
        }
        return uri.getPath();
    }

    public static String readString(Builder builder) {
        return URIContentLoaderFactory.readString(builder.build());
    }

    public static URIContentLoader buildLoader(URI uri, Workflow workflow, Optional<ParserContext> context, String authRef) {
        Builder builder = new Builder(uri).withWorkflow(workflow).withAuthRef(authRef);
        context.map(c -> c.getContext().getClassLoader()).ifPresent(builder::withClassloader);
        ServerlessWorkflowUtils.getBaseURI(workflow).ifPresent(builder::withBaseURI);
        return builder.build();
    }

    public static byte[] readBytes(String uriStr, Workflow workflow, ParserContext parserContext) {
        return URIContentLoaderFactory.readBytes(uriStr, workflow, Optional.ofNullable(parserContext));
    }

    public static byte[] readBytes(String uriStr, Workflow workflow, Optional<ParserContext> parserContext) {
        return URIContentLoaderFactory.readAllBytes(URIContentLoaderFactory.buildLoader(URI.create(uriStr), workflow, parserContext, null));
    }

    public static Builder builder(URI uri) {
        return new Builder(uri);
    }

    public static Builder builder(String uri) {
        return new Builder(URI.create(URLEncoder.encode(uri, Charset.defaultCharset())));
    }

    public static URI compoundURI(URI baseURI, URI uri) {
        if (uri.getScheme() != null) {
            return uri;
        }
        URIContentLoaderType type = URIContentLoaderType.from(baseURI);
        String basePath = type.trimLast(URIContentLoaderFactory.uriToPath(type, baseURI));
        String additionalPath = URIContentLoaderFactory.uriToPath(type, uri);
        String path = type.isAbsolutePath(additionalPath) ? additionalPath : type.concat(basePath, additionalPath);
        try {
            return new URI(type.toString().toLowerCase(), baseURI.getAuthority(), path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private URIContentLoaderFactory() {
    }

    public static class Builder {
        private URI uri;
        private ClassLoader cl;
        private Workflow workflow;
        private String authRef;
        private URI baseURI;

        private Builder(URI uri) {
            this.uri = uri;
        }

        public Builder withClassloader(ClassLoader cl) {
            this.cl = cl;
            return this;
        }

        public Builder withWorkflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder withAuthRef(String authRef) {
            this.authRef = authRef;
            return this;
        }

        public Builder withBaseURI(URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        public URIContentLoader build() {
            URI finalURI = this.baseURI != null ? URIContentLoaderFactory.compoundURI(this.baseURI, this.uri) : this.uri;
            switch (URIContentLoaderType.from(finalURI)) {
                default: {
                    return new FileContentLoader(finalURI, new ClassPathContentLoader(this.uri, Optional.ofNullable(this.cl), new URIContentLoader[0]));
                }
                case HTTP: {
                    return new HttpContentLoader(finalURI, Optional.ofNullable(this.workflow), this.authRef);
                }
                case CLASSPATH: 
            }
            Optional<ClassLoader> optionalCl = Optional.ofNullable(this.cl);
            return finalURI == this.uri ? new ClassPathContentLoader(finalURI, optionalCl, new URIContentLoader[0]) : new ClassPathContentLoader(finalURI, optionalCl, new ClassPathContentLoader(this.uri, optionalCl, new URIContentLoader[0]));
        }
    }
}

