/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jbpm.ruleflow.core.factory.MappableNodeFactory;
import org.kie.kogito.jackson.utils.JsonNodeVisitor;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.serverless.workflow.parser.handlers.MappingSetter;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public class MappingUtils {
    public static <T extends MappableNodeFactory<?>> T addMapping(T nodeFactory, String inputVar, String outputVar) {
        return (T)nodeFactory.inMapping(inputVar, "Parameter").outMapping("Result", outputVar);
    }

    public static final void processArgs(Workflow workflow, JsonNode functionArgs, MappingSetter setter) {
        if (functionArgs.isObject()) {
            MappingUtils.functionsToMap(workflow, functionArgs).forEach((key, value) -> setter.accept((String)key, value));
        } else {
            Object object = MappingUtils.functionReference(workflow, JsonObjectUtils.simpleToJavaValue((JsonNode)functionArgs));
            setter.accept(object);
        }
    }

    private static Map<String, Object> functionsToMap(Workflow workflow, JsonNode jsonNode) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (jsonNode != null) {
            Iterator iter = jsonNode.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                map.put((String)entry.getKey(), MappingUtils.functionReference(workflow, JsonObjectUtils.simpleToJavaValue((JsonNode)((JsonNode)entry.getValue()))));
            }
        }
        return map;
    }

    private static Object functionReference(Workflow workflow, Object object) {
        if (object instanceof JsonNode) {
            return JsonNodeVisitor.transformTextNode((JsonNode)((JsonNode)object), node -> JsonObjectUtils.fromValue((Object)ExpressionHandlerUtils.replaceExpr((Workflow)workflow, (String)node.asText())));
        }
        if (object instanceof CharSequence) {
            return ExpressionHandlerUtils.replaceExpr((Workflow)workflow, (String)object.toString());
        }
        return object;
    }
}

