/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.rpc;

import com.google.protobuf.DescriptorProtos;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDescriptorHolder {
    public static final String DESCRIPTOR_PATH = "protobuf/descriptor-sets/output.protobin";
    private static final Logger logger = LoggerFactory.getLogger(FileDescriptorHolder.class);
    private static final FileDescriptorHolder instance = new FileDescriptorHolder();
    private Optional<DescriptorProtos.FileDescriptorSet> fdSet = FileDescriptorHolder.loadFileDescriptorSet();

    public static FileDescriptorHolder get() {
        return instance;
    }

    private FileDescriptorHolder() {
    }

    public Optional<DescriptorProtos.FileDescriptorSet> descriptor() {
        return this.fdSet;
    }

    protected static Optional<DescriptorProtos.FileDescriptorSet> loadFileDescriptorSet() {
        Optional<DescriptorProtos.FileDescriptorSet> optional;
        block8: {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DESCRIPTOR_PATH);
            try {
                Optional<DescriptorProtos.FileDescriptorSet> optional2 = optional = inputStream != null ? Optional.of(((DescriptorProtos.FileDescriptorSet.Builder)DescriptorProtos.FileDescriptorSet.newBuilder().mergeFrom(inputStream.readAllBytes())).build()) : Optional.empty();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn("Error loading descriptor set", (Throwable)e);
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }
}

