/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIFactory {
    private static final Logger logger = LoggerFactory.getLogger(OpenAPIFactory.class);

    private OpenAPIFactory() {
    }

    public static OpenAPI getOpenAPI(URI uri, Workflow workflow, FunctionDefinition function, Optional<ParserContext> context) {
        SwaggerParseResult result = new OpenAPIParser().readContents(URIContentLoaderFactory.readString((URIContentLoader)URIContentLoaderFactory.buildLoader((URI)uri, (Workflow)workflow, context, (String)function.getAuthRef())), null, null);
        OpenAPI openAPI = result.getOpenAPI();
        if (openAPI == null) {
            throw new IllegalArgumentException("Problem parsing uri " + uri + " Messages" + result.getMessages());
        }
        logger.debug("OpenAPI parser messages {}", (Object)result.getMessages());
        return openAPI;
    }
}

