/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.kie.kogito.process.workitems.impl.expr.ExpressionWorkItemResolver;

public class ObjectResolver
extends ExpressionWorkItemResolver {
    public ObjectResolver(String exprLang, String jsonPathExpr, String paramName) {
        super(exprLang, jsonPathExpr, paramName);
    }

    protected Object evalExpression(Object inputModel) {
        return this.readValue((JsonNode)this.expressionHandler.parse(this.expression).eval(inputModel, JsonNode.class));
    }

    private Object readValue(JsonNode node) {
        switch (node.getNodeType()) {
            case NUMBER: {
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                return node.asDouble();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                return this.readArray((ArrayNode)node);
            }
            case STRING: {
                return node.asText();
            }
        }
        return node;
    }

    private Object readArray(ArrayNode node) {
        Iterator elements = node.elements();
        ArrayList<Object> result = new ArrayList<Object>();
        while (elements.hasNext()) {
            result.add(this.readValue((JsonNode)elements.next()));
        }
        return result;
    }
}

