/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.workitems.impl.expr.Expression;
import org.kie.kogito.process.workitems.impl.expr.ExpressionHandlerFactory;
import org.kie.kogito.process.workitems.impl.expr.ExpressionWorkItemResolver;

public class JsonNodeResolver
extends ExpressionWorkItemResolver {
    public JsonNodeResolver(String exprLang, String jsonPathExpr, String paramName) {
        super(exprLang, jsonPathExpr, paramName);
    }

    private JsonNode parse(String exprStr) {
        if (ExpressionHandlerFactory.get((String)this.language, (String)exprStr).isValid()) {
            return TextNode.valueOf((String)exprStr);
        }
        ObjectMapper objectMapper = ObjectMapperFactory.get();
        try {
            return objectMapper.readTree(exprStr);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to parse input model from ordinary String to Json tree", e);
        }
    }

    protected Object evalExpression(Object inputModel) {
        return this.processInputModel(inputModel, this.parse(this.expression));
    }

    private JsonNode processInputModel(Object inputModel, JsonNode expression) {
        if (expression.isArray()) {
            JsonNode processedDefinition = expression.deepCopy();
            for (int index = 0; index < processedDefinition.size(); ++index) {
                ((ArrayNode)processedDefinition).set(index, this.processInputModel(inputModel, processedDefinition.get(index)));
            }
            return processedDefinition;
        }
        if (expression.isValueNode()) {
            String jsonPathExpr = expression.asText();
            Expression evalExpr = ExpressionHandlerFactory.get((String)this.language, (String)jsonPathExpr);
            if (evalExpr.isValid()) {
                return (JsonNode)evalExpr.eval(inputModel, JsonNode.class);
            }
            return expression.deepCopy();
        }
        JsonNode processedDefinition = expression.deepCopy();
        Iterator fields = processedDefinition.fields();
        while (fields.hasNext()) {
            Map.Entry jsonField = (Map.Entry)fields.next();
            ((ObjectNode)processedDefinition).replace((String)jsonField.getKey(), this.processInputModel(inputModel, (JsonNode)jsonField.getValue()));
        }
        return processedDefinition;
    }
}

