/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.actions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.jbpm.process.instance.impl.Action;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;
import org.kie.kogito.serverless.workflow.actions.ActionUtils;

public abstract class BaseExpressionAction
implements Action {
    protected final Expression expr;
    protected final String modelVar;
    protected final String[] addInputVars;

    public BaseExpressionAction(String lang, String expr, String inputVar, String ... addVars) {
        this.expr = ExpressionHandlerFactory.get((String)lang, (String)expr);
        this.modelVar = inputVar;
        this.addInputVars = addVars;
    }

    protected final <T> T evaluate(KogitoProcessContext context, Class<T> resultClass) {
        JsonNode node = ActionUtils.getJsonNode(context, this.modelVar);
        if (node instanceof ObjectNode) {
            for (String addVar : this.addInputVars) {
                JsonObjectUtils.addToNode((String)addVar, (Object)context.getVariable(addVar), (ObjectNode)((ObjectNode)node));
            }
        }
        Object result = this.expr.eval((Object)node, resultClass, context);
        if (node instanceof ObjectNode) {
            for (String addVar : this.addInputVars) {
                context.setVariable(addVar, JsonObjectUtils.toJavaValue((JsonNode)((ObjectNode)node).remove(addVar)));
            }
        }
        return (T)result;
    }

    protected final <T> T assign(KogitoProcessContext context, T value) {
        this.expr.assign((Object)ActionUtils.getJsonNode(context, this.modelVar), value, context);
        return value;
    }
}

