/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Supplier;
import org.jbpm.process.instance.impl.actions.ProduceEventAction;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;
import org.kie.kogito.services.event.impl.AbstractMessageProducer;

public class SWFProduceEventAction
extends ProduceEventAction<JsonNode> {
    private static final long serialVersionUID = 1L;
    private Expression expr;
    private JsonNode value;

    public SWFProduceEventAction(String triggerName, String varName, Supplier<AbstractMessageProducer<JsonNode, ?>> supplier, String exprLang, String data) {
        super(triggerName, varName, supplier);
        if (data != null) {
            this.expr = ExpressionHandlerFactory.get((String)exprLang, (String)data);
            if (!this.expr.isValid()) {
                try {
                    this.value = ObjectMapperFactory.get().readTree(data);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Data " + data + " is not valid json not valid expression");
                }
            }
        }
    }

    public JsonNode getObject(Object object, KogitoProcessContext context) {
        if (this.value != null) {
            return this.value;
        }
        if (this.expr != null) {
            return (JsonNode)this.expr.eval(object, JsonNode.class, context);
        }
        return JsonObjectUtils.fromValue((Object)object);
    }
}

