/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.util.Map;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.jbpm.workflow.core.WorkflowInputModelValidator;
import org.json.JSONObject;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInputSchemaValidator
implements WorkflowInputModelValidator {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DataInputSchemaValidator.class);
    protected final String schema;
    protected final boolean failOnValidationErrors;

    public DataInputSchemaValidator(String schema, boolean failOnValidationErrors) {
        this.schema = schema;
        this.failOnValidationErrors = failOnValidationErrors;
    }

    public void validate(Map<String, Object> model) {
        ObjectMapper mapper = ObjectMapperFactory.get();
        try {
            SchemaLoader.load((JSONObject)((JSONObject)mapper.readValue(URIContentLoaderFactory.readAllBytes(URIContentLoaderFactory.runtimeLoader(this.schema)), JSONObject.class))).validate(mapper.convertValue(model.getOrDefault("workflowdata", NullNode.instance), JSONObject.class));
        }
        catch (ValidationException ex) {
            this.handleException(ex, ex.getCausingExceptions().isEmpty() ? ex : ex.getCausingExceptions());
        }
        catch (IOException ex) {
            this.handleException(ex, ex);
        }
    }

    private void handleException(Throwable ex, Object toAppend) {
        String validationError = String.format("Error validating input schema: %s", toAppend);
        logger.warn(validationError, ex);
        if (this.failOnValidationErrors) {
            throw new IllegalArgumentException(validationError);
        }
    }
}

