/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.CachedContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;

public class ClassPathContentLoader
extends CachedContentLoader {
    private final Optional<URL> resource;
    private final String path;

    public ClassPathContentLoader(URI uri, Optional<ClassLoader> cl) {
        super(uri);
        this.path = ClassPathContentLoader.getPath(uri);
        this.resource = Optional.ofNullable(cl.orElse(Thread.currentThread().getContextClassLoader()).getResource(this.path));
    }

    private static String getPath(URI uri) {
        String path = uri.getPath();
        Objects.requireNonNull(path, "classpath cannot be null");
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public Optional<URL> getResource() {
        return this.resource;
    }

    @Override
    protected byte[] loadURI(URI uri) {
        return this.resource.map(this::loadBytes).orElseThrow(() -> new IllegalArgumentException("cannot find classpath resource " + this.path));
    }

    private byte[] loadBytes(URL r) {
        byte[] byArray;
        block8: {
            InputStream is = r.openStream();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            }
            is.close();
        }
        return byArray;
    }

    @Override
    public URIContentLoaderType type() {
        return URIContentLoaderType.CLASSPATH;
    }
}

