/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import io.serverlessworkflow.api.Workflow;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.ClassPathContentLoader;
import org.kie.kogito.serverless.workflow.io.FileContentLoader;
import org.kie.kogito.serverless.workflow.io.HttpContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;

public class URIContentLoaderFactory {
    public static byte[] readAllBytes(URIContentLoader loader) {
        byte[] byArray;
        block8: {
            InputStream is = loader.getInputStream();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static URIContentLoader runtimeLoader(String uriStr) {
        URI uri = URI.create(uriStr);
        return URIContentLoaderFactory.loader(uri, Optional.empty(), Optional.of(new ClassPathContentLoader(uri, Optional.empty())), Optional.empty(), null);
    }

    public static URIContentLoader buildLoader(URI uri, ClassLoader cl, Workflow workflow, String authRef) {
        return URIContentLoaderFactory.loader(uri, Optional.of(cl), Optional.empty(), Optional.of(workflow), authRef);
    }

    public static URIContentLoader loader(URI uri, Optional<ClassLoader> cl, Optional<URIContentLoader> fallback, Optional<Workflow> workflow, String authRef) {
        switch (URIContentLoaderType.from(uri)) {
            case FILE: {
                return new FileContentLoader(uri, fallback);
            }
            case HTTP: {
                return new HttpContentLoader(uri, fallback, workflow, authRef);
            }
        }
        return new ClassPathContentLoader(uri, cl);
    }

    private URIContentLoaderFactory() {
    }
}

