/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.actions;

import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.jbpm.workflow.core.WorkflowModelValidator;
import org.json.JSONObject;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator
implements WorkflowModelValidator {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaValidator.class);
    protected final String schemaRef;
    protected final boolean failOnValidationErrors;
    private final AtomicReference<Schema> schemaObject = new AtomicReference();

    public JsonSchemaValidator(String schema, boolean failOnValidationErrors) {
        this.schemaRef = schema;
        this.failOnValidationErrors = failOnValidationErrors;
    }

    public void validate(Map<String, Object> model) {
        try {
            this.load().validate(ObjectMapperFactory.get().convertValue(model.getOrDefault("workflowdata", NullNode.instance), JSONObject.class));
        }
        catch (ValidationException ex) {
            this.handleException(ex, ex.getCausingExceptions().isEmpty() ? ex : ex.getCausingExceptions());
        }
        catch (IOException ex) {
            this.handleException(ex, ex);
        }
    }

    public Schema load() throws IOException {
        Schema result = this.schemaObject.get();
        if (result == null) {
            result = SchemaLoader.builder().schemaJson((JSONObject)ObjectMapperFactory.get().readValue(URIContentLoaderFactory.readAllBytes(URIContentLoaderFactory.runtimeLoader(this.schemaRef)), JSONObject.class)).resolutionScope(this.schemaRef).schemaClient(SchemaClient.classPathAwareClient()).build().load().build();
            this.schemaObject.set(result);
        }
        return result;
    }

    private void handleException(Throwable ex, Object toAppend) {
        String validationError = String.format("Error validating schema: %s", toAppend);
        logger.warn(validationError, ex);
        if (this.failOnValidationErrors) {
            throw new IllegalArgumentException(validationError);
        }
    }
}

