/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.auth.AuthDefinition;
import io.serverlessworkflow.api.auth.BasicAuthDefinition;
import io.serverlessworkflow.api.auth.BearerAuthDefinition;
import io.serverlessworkflow.api.auth.OauthDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Base64;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.FallbackContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;
import org.kie.kogito.serverless.workflow.utils.BuildEvaluator;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;
import org.kogito.workitem.rest.auth.ClientOAuth2AuthToken;
import org.kogito.workitem.rest.auth.PasswordOAuth2AuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpContentLoader
extends FallbackContentLoader {
    private static final Logger logger = LoggerFactory.getLogger(HttpContentLoader.class);
    private Optional<Workflow> workflow;
    private String authRef;

    public HttpContentLoader(URI uri, Optional<URIContentLoader> fallback, Optional<Workflow> workflow, String authRef) {
        super(uri, fallback);
        this.workflow = workflow;
        this.authRef = authRef;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] loadURI(URI u) {
        try {
            HttpURLConnection conn = (HttpURLConnection)u.toURL().openConnection();
            conn.setRequestProperty("Accept", "application/json,application/yaml,application/yml,application/text,text/*,*/*");
            this.workflow.map(Workflow::getAuth).filter(auth -> Objects.equals(auth.getName(), this.authRef)).ifPresent(auth -> this.addAuth(conn, (AuthDefinition)auth));
            int code = conn.getResponseCode();
            if (code == 200) {
                try (InputStream is = conn.getInputStream();){
                    byte[] byArray = is.readAllBytes();
                    return byArray;
                }
            }
            InputStream is = conn.getErrorStream();
            try {
                throw new IllegalArgumentException(String.format("Failed to fetch remote file: %s. Status code is %d and response: %n %s", u, code, is == null ? "" : new String(is.readAllBytes())));
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    private void addAuth(HttpURLConnection conn, AuthDefinition auth) {
        switch (auth.getScheme()) {
            case BASIC: {
                this.basicAuth(conn, auth.getBasicauth());
                break;
            }
            case BEARER: {
                this.bearerAuth(conn, auth.getBearerauth());
                break;
            }
            case OAUTH_2: {
                this.oauth2Auth(conn, auth.getOauth());
            }
        }
    }

    private void oauth2Auth(HttpURLConnection conn, OauthDefinition oauth) {
        ClientOAuth2AuthToken tokenRetriever;
        HashMap<String, String> parameters = new HashMap<String, String>();
        String tokenUrl = (String)oauth.getMetadata().get("tokenURL");
        String refreshUrl = (String)oauth.getMetadata().get("refreshURL");
        if (tokenUrl == null) {
            logger.warn("Need to add property tokenURL in metadata for oauth auth");
            return;
        }
        switch (oauth.getGrantType()) {
            case CLIENT_CREDENTIALS: {
                tokenRetriever = new ClientOAuth2AuthToken(tokenUrl, refreshUrl);
                parameters.put("clientId", this.eval(oauth.getClientId()));
                parameters.put("clientSecret", this.eval(oauth.getClientSecret()));
                break;
            }
            case PASSWORD: {
                tokenRetriever = new PasswordOAuth2AuthToken(tokenUrl, refreshUrl);
                parameters.put("Username", this.eval(oauth.getClientId()));
                parameters.put("Password", this.eval(oauth.getClientSecret()));
                break;
            }
            default: {
                logger.warn("Unsupported grant type {}", (Object)oauth.getGrantType());
                return;
            }
        }
        HttpContentLoader.bearerAuth(conn, tokenRetriever.getToken(parameters));
    }

    private void bearerAuth(HttpURLConnection conn, BearerAuthDefinition bearerAuth) {
        HttpContentLoader.bearerAuth(conn, this.eval(bearerAuth.getToken()));
    }

    private static void bearerAuth(HttpURLConnection conn, String token) {
        conn.setRequestProperty("Authorization", "Bearer " + token);
    }

    private String eval(String expr) {
        return BuildEvaluator.eval((String)ExpressionHandlerUtils.trimExpr((String)expr));
    }

    private void basicAuth(HttpURLConnection conn, BasicAuthDefinition basicAuth) {
        conn.setRequestProperty("Authorization", "Basic " + this.encode(this.eval(basicAuth.getUsername()) + ":" + this.eval(basicAuth.getPassword())));
    }

    private String encode(String str) {
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    @Override
    public URIContentLoaderType type() {
        return URIContentLoaderType.HTTP;
    }
}

