/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.workitem.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkflowWorkItemHandler
implements KogitoWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowWorkItemHandler.class);

    public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(workItem.getParameters());
        parameters.remove("Parameter");
        logger.debug("Workflow workitem {} will be invoked with parameters {}", (Object)workItem.getName(), parameters);
        manager.completeWorkItem(workItem.getStringId(), Collections.singletonMap("Result", JsonObjectUtils.fromValue((Object)this.internalExecute(workItem, parameters))), new Policy[0]);
    }

    protected abstract Object internalExecute(KogitoWorkItem var1, Map<String, Object> var2);

    protected static <V> V buildBody(Map<String, Object> params, Class<V> clazz) {
        for (Object obj : params.values()) {
            if (obj == null || !clazz.isAssignableFrom(obj.getClass())) continue;
            return clazz.cast(obj);
        }
        return (V)ObjectMapperFactory.get().convertValue(params, clazz);
    }

    public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
    }
}

