/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.actions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jbpm.workflow.core.WorkflowModelValidator;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator
implements WorkflowModelValidator {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaValidator.class);
    protected final String schemaRef;
    protected final boolean failOnValidationErrors;
    private final AtomicReference<JsonSchema> schemaObject = new AtomicReference();

    public JsonSchemaValidator(String schema, boolean failOnValidationErrors) {
        this.schemaRef = schema;
        this.failOnValidationErrors = failOnValidationErrors;
    }

    public void validate(Map<String, Object> model) {
        Set report = this.getSchema().validate((JsonNode)model.getOrDefault("workflowdata", NullNode.instance));
        if (!report.isEmpty()) {
            StringBuilder sb = new StringBuilder("There are JsonSchema validation errors:");
            report.forEach(m -> sb.append(System.lineSeparator()).append(m.getMessage()));
            String validationMessage = sb.toString();
            logger.warn(validationMessage);
            if (this.failOnValidationErrors) {
                throw new IllegalArgumentException(validationMessage);
            }
        }
    }

    public <T> Optional<T> schema(Class<T> clazz) {
        return JsonNode.class.isAssignableFrom(clazz) ? Optional.of(this.getSchema().getSchemaNode()) : Optional.empty();
    }

    private JsonSchema getSchema() {
        try {
            JsonSchema result = this.schemaObject.get();
            if (result == null) {
                result = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7).getSchema(ObjectMapperFactory.get().readTree(URIContentLoaderFactory.readAllBytes(URIContentLoaderFactory.runtimeLoader(this.schemaRef))));
                this.schemaObject.set(result);
            }
            return result;
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
    }
}

