/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import io.serverlessworkflow.api.Workflow;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.ClassPathContentLoader;
import org.kie.kogito.serverless.workflow.io.FileContentLoader;
import org.kie.kogito.serverless.workflow.io.HttpContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;

public class URIContentLoaderFactory {
    public static byte[] readAllBytes(URIContentLoader loader) {
        byte[] byArray;
        block8: {
            InputStream is = loader.getInputStream();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static URIContentLoader runtimeLoader(String uriStr) {
        URI uri = URI.create(uriStr);
        Builder builder = new Builder(uri);
        builder.withFallback(new ClassPathContentLoader(uri, Optional.empty()));
        return builder.build();
    }

    public static URIContentLoader buildLoader(URI uri, ClassLoader cl, Workflow workflow, String authRef) {
        return new Builder(uri).withClassloader(cl).withWorkflow(workflow).withAuthRef(authRef).build();
    }

    @Deprecated
    public static URIContentLoader loader(URI uri, Optional<ClassLoader> cl, Optional<URIContentLoader> fallback, Optional<Workflow> workflow, String authRef) {
        Builder builder = new Builder(uri);
        cl.ifPresent(builder::withClassloader);
        fallback.ifPresent(builder::withFallback);
        workflow.ifPresent(builder::withWorkflow);
        builder.withAuthRef(authRef);
        return builder.build();
    }

    public static Builder builder(URI uri) {
        return new Builder(uri);
    }

    private URIContentLoaderFactory() {
    }

    public static class Builder {
        private URI uri;
        private ClassLoader cl;
        private URIContentLoader fallback;
        private Workflow workflow;
        private String authRef;
        private String baseURI;

        private Builder(URI uri) {
            this.uri = uri;
        }

        public Builder withClassloader(ClassLoader cl) {
            this.cl = cl;
            return this;
        }

        public Builder withFallback(URIContentLoader fallback) {
            this.fallback = fallback;
            return this;
        }

        public Builder withWorkflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder withAuthRef(String authRef) {
            this.authRef = authRef;
            return this;
        }

        public Builder withBaseURI(String baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        public URIContentLoader build() {
            if (this.uri.getScheme() == null) {
                if (this.baseURI != null) {
                    this.uri = URI.create(this.baseURI + "/" + this.uri.toString());
                } else {
                    return new ClassPathContentLoader(this.uri, Optional.ofNullable(this.cl));
                }
            }
            switch (URIContentLoaderType.from(this.uri)) {
                case FILE: {
                    return new FileContentLoader(this.uri, Optional.ofNullable(this.fallback));
                }
                case HTTP: {
                    return new HttpContentLoader(this.uri, Optional.ofNullable(this.fallback), Optional.ofNullable(this.workflow), this.authRef);
                }
            }
            return new ClassPathContentLoader(this.uri, Optional.ofNullable(this.cl));
        }
    }
}

